theory question_59_0

imports Main

begin

typedecl entity
typedecl event

consts
  Chordates :: "entity ⇒ bool"
  CompleteDigestiveSystem :: "entity ⇒ bool"
  ClosedCirculatorySystem :: "entity ⇒ bool"
  Vertebrates :: "entity ⇒ bool"

(* Explanation 1: Chordates have a complete digestive system and a closed circulatory system. *)
axiomatization where
  explanation_1: "∀x. Chordates x ∧ CompleteDigestiveSystem x ∧ ClosedCirculatorySystem x"

(* Explanation 2: Vertebrates have a closed circulatory system. *)
axiomatization where
  explanation_2: "∀x. Vertebrates x ∧ ClosedCirculatorySystem x"  

theorem hypothesis:
  assumes asm: "Chordates x"
  (* Hypothesis: Chordates belong to the group of animals known as vertebrates. *)
  shows "∃x. Vertebrates x ∧ Chordates x"
proof -
  from asm have "Chordates x" by simp
  then obtain e1 where e1: "CompleteDigestiveSystem x ∧ ClosedCirculatorySystem x" using explanation_1 by blast
  then have "Vertebrates x" using explanation_2 by blast
  show ?thesis using asm e1 by simp
qed

end
