theory question_96_0

imports Main

begin
typedecl entity
typedecl event

consts
  People :: "entity ⇒ bool"
  Children :: "entity ⇒ bool"
  Adults :: "entity ⇒ bool"
  Swimming :: "event ⇒ bool"
  Group :: "entity ⇒ bool"
  InLargePool :: "event ⇒ bool"
  WithRedStaircase :: "event ⇒ bool"

(* Explanation 1: Both children and adults are people. *)
axiomatization where
  explanation_1: "∀x. Children x ⟶ People x"
axiomatization where
  explanation_2: "∀x. Adults x ⟶ People x"

theorem hypothesis:
  (* Premise: Children and adults swim in a large pool with a red staircase. *)
  assumes asm: "Children x ∧ Adults y ∧ People x ∧ People y ∧ Swimming e ∧ Agent e x ∧ Agent e y ∧ InLargePool e ∧ WithRedStaircase e"
  (* Hypothesis: A group of people are swimming. *)
  shows "∃x e. People x ∧ Group x ∧ Swimming e ∧ Agent e x"
proof -
  from asm have "Children x ∧ People x" by blast
  from asm have "Adults y ∧ People y" by blast
  then have "People x ∧ People y" by blast
  then show ?thesis using `People x` by blast
qed

end
