import nlpaug.augmenter.word as naw
import csv
import re

data = []
with open("data-augmentation-for-trec/data/labeled.tsv") as file:
    tsv_file = csv.reader(file, delimiter="\t")
    for line in tsv_file:
        data.append(line[0])
data = data[1:]

split_data = []
for i in range(len(data)):
  split_data.append(data[i].split(" ", 1))

print("Example of data:", split_data[0])

syn_data = []
conv_aug = naw.SynonymAug(aug_src='wordnet', lang='eng', aug_p=0.1)

for _ in range(1): # 9 (low-resource) or 2 (half)
  for i in range(len(split_data)):
    txt = split_data[i][1]
    new_txt = conv_aug.augment(txt)[0]
    syn_data.append(split_data[i][0]+' '+new_txt)

syn_data = syn_data + data

print("size of train data:", len(split_data))
print("size of augmented data:", len(syn_data))

with open("data-augmentation-for-trec/aug_data/labeled.tsv", "w") as file:
  writer = csv.writer(file)
  writer.writerow(["fine_label utterance"])


with open("data-augmentation-for-trec/aug_data/labeled.tsv", "a") as file:
  writer = csv.writer(file, delimiter='\n', quotechar='', quoting=csv.QUOTE_NONE)
  writer.writerow(syn_data)


