export PYTHONPATH="/home/dyhwang/workplace/paper_work/BLINK"
export GPUS=(0 1 2 3 4 5 6 7)
export RUNS=(a b c d)

export RUN=${RUNS[0]}
export CUDA_VISIBLE_DEVICES=${GPUS[0]}

export APPROACH="/home/dyhwang/workplace/paper_work/data/zeshel/low-resource"
export INPUT="${APPROACH}"
export OUTPUT="${APPROACH}/${RUN}"


echo "Launching evaluation for run ${RUN} on GPU ${CUDA_VISIBLE_DEVICES} for approach ${APPROACH}"
python blink/biencoder/eval_biencoder.py \
  --data_path ${INPUT} \
  --path_to_model ${OUTPUT}/pytorch_model.bin \
  --output_path ${OUTPUT}/eval \
  --encode_batch_size 8 --eval_batch_size 1 --top_k 64 --save_topk_result \
  --bert_model bert-base-uncased --mode test \
  --zeshel True --data_parallel
