import argparse

# evaluating configurations
parser = argparse.ArgumentParser(description="configs for training biencoder and crossencoder")
parser.add_argument("--max_context_length", default=128, type=int)
parser.add_argument("--max_cand_length", default=128, type=int)
parser.add_argument("--au_num", default=1000, type=int, help="The number of samples for each domain for computing alignment and uniform.")
parser.add_argument("--bert_model", default="bert-base-uncased", type=str)
parser.add_argument("--lowercase", action="store_false", help="Whether to lower case the input text. True for uncased models, False for cased models.")
parser.add_argument("--data_path", default="dataset", type=str, help="The path to the train data.")
parser.add_argument("--path_to_model", default="./random3_layerid0_epsilon32/epoch_4/pytorch_model.bin", type=str, required=False, help="The full path to the model to load.")
parser.add_argument("--output_path", default="./random3_layerid0_epsilon32/epoch_4", type=str, help="The output directory where generated output file (model, etc.) is to be dumped.")

parser.add_argument("--eval_batch_size", default=8, type=int, help="Total batch size for evaluation.")
parser.add_argument("--train_batch_size", default=16, type=int, help="Total batch size for evaluation.")
parser.add_argument("--top_k", default=64, type=int) 
parser.add_argument("--epsilon", default=1.0, type=float, help="Step length for the A.")
parser.add_argument("--layer_id", default=0, type=int, help="the outputs of layer for turbulence.")
parser.add_argument("--cands_num", default=64, type=int) 
parser.add_argument("--mode", default="heldout_train_unseen", type=str, help="Train / val / test")
parser.add_argument("--save_topk_result", action="store_true", help="Whether to save prediction results.")
parser.add_argument("--encode_batch_size", default=8, type=int, help="Batch size for encoding.")
parser.add_argument("--getk_batch_size", default=1, type=int, help="Batch size for geting top k.")
parser.add_argument("--cand_pool_path", default=None, type=str, help="Path for cached candidate pool (id tokenization of candidates)")
parser.add_argument("--cand_encode_path", default=None, type=str, help="Path for cached candidate encoding")
args = parser.parse_args()
