from script_train.embed_config import FldEmbed
import logging


SIZE = 200
input_fields = ['token', 'char', 'phoneme', 'pos_en']


logging.basicConfig(filename = 'English' + str(field_num) + '.txt',
                    filemode='w',
                    format='%(asctime)s,%(msecs)d %(name)s %(levelname)s %(message)s',
                    datefmt='%H:%M:%S',
                    level=logging.DEBUG)
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)
logging.debug('test')


FldEmbed_Dir_Dict = {
    1: 'embeddings/fieldembed/WikiEnglish/word/token/cb-it5-w5-ng10-lr0.025-smp0.001-nsexp0.75-th8/LF1-SmpGrT/',
    2: 'embeddings/fieldembed/WikiEnglish/word/token_char/cb-it5-w5-ng10-lr0.025-smp0.001-nsexp0.75-th8/LF3-SmpGrT/',
    3: 'embeddings/fieldembed/WikiEnglish/word/token_char_phoneme/cb-it5-w5-ng10-lr0.025-smp0.001-nsexp0.75-th8/LF3-SmpGrT/',
    4: 'embeddings/fieldembed/WikiEnglish/word/token_char_phoneme_pos_en/cb-it5-w5-ng10-lr0.025-smp0.001-nsexp0.75-th8/LF3-SmpGrT/'
}

idx = len(input_fields) 
FldEmbed_Dir = FldEmbed_Dir_Dict[idx]

fldembed = FldEmbed(FldEmbed_Dir, SIZE)


wv_token = fldembed.weights['token']
print(len(wv_token.index2word))

print(wv_token.lexical_evals(language = 'en')) # for Chinese embeddings evaluation, using language = 'cn'.

