#!/bin/bash
i=6
exper_name="debug${i}"
res=`screen -ls`
if [[ ${res} =~ "${exper_name}" ]]
then
    echo 'screen $exper_name already created.'
else
    screen -dmS $exper_name 
    echo 'create screen $exper_name'
fi

# 8020
screen -r $exper_name -X stuff "conda activate py3.7\n"
screen -r $exper_name -X stuff "pgnn\n"
screen -r $exper_name -X stuff "cd src\n"

# 2080ti
# screen -r $exper_name -X stuff "source activate jt-dep\n"
# screen -r $exper_name -X stuff "cd /home/taoji/data/PGNN-Transformer/PGNN-dep-parser/src\n"

debug_data_dir=/home/taoji/data/Github/gnn-dep-parsing/data
data_dir=/home/taoji/data/dataset/DEP/PTB
# data_dir=/home/taoji/data/PTB
ckpt_dir=../ckpts/$exper_name

screen -r $exper_name -X stuff "CUDA_VISIBLE_DEVICES=4 python train.py \
--TRAIN $data_dir/train.conllu \
--DEV $data_dir/dev.conllu \
--TEST $data_dir/test.conllu \
--GLOVE /home/taoji/data/dataset/cut_glove.vec.gz \
--PRED_DEV $ckpt_dir/dev.pred \
--PRED_TEST $ckpt_dir/test.pred \
--LOG $ckpt_dir/$exper_name.log \
--MIN_COUNT 2 "

screen -r $exper_name -X stuff "--LAST $ckpt_dir/last.pt \
--BEST $ckpt_dir/best.pt \
--SEED 666 \
--N_EPOCH 1000 \
--N_BATCH 100 \
--N_WORKER 2 \
--LR 0.0012 \
--BETAS 0.9 0.98 \
--EPS 1e-6 \
--LR_DECAY 0.75 \
--LR_ANNEAL 10000 \
--LR_WARM 800 \
--CLIP 5.0 "

screen -r $exper_name -X stuff "--IS_FIX_GLOVE \
--MODEL_TYPE Xformer \
--D_TAG 100 \
--N_RNN_LAYER 3 \
--D_RNN_HID 400 \
--D_ARC 512 \
--D_REL 128 \
--EMB_DROP 0.33 \
--RNN_DROP 0.33 \
--MLP_DROP 0.33 "

screen -r $exper_name -X stuff "--D_MODEL 200 \
--STEP_VALID 5 \
--STEP_UPDATE 2 \
--N_XFMR_LAYER 8 \
--N_HEAD 8 \
--D_FF 800 \
--XFMR_DROP 0.2 \
--PE_DROP 0.2 \
--PE_TYPE add \
--N_PE 200 \n"

echo 'cmd finish!'
