import sys


def process_sentence(sentence):
    tokens = sentence.strip().split()
    new_tokens = [tokens[0]]
    for token in tokens[1:]:
        if token.count('_') < 5:
            # ￨ \U+FFF8
            suffix = '￨'.join(['#'] * 5)
        else:
            parts = token.split('_')
            token = '_'.join(parts[:-5])
            suffix = '￨'.join(parts[-5:])
        new_tokens.append(token + '￨' + suffix)
    return ' '.join(new_tokens)


if __name__ == '__main__':
    for line in sys.stdin:
        print(process_sentence(line))
