/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class LongKeyAnalyzer
extends AbstractKeyAnalyzer<Long>
implements Serializable {
    private static final long serialVersionUID = -7611788114037795486L;
    public static final LongKeyAnalyzer INSTANCE = new LongKeyAnalyzer();
    private static final long MSB = Integer.MIN_VALUE;

    private static long mask(int n) {
        return Integer.MIN_VALUE >>> n;
    }

    @Override
    public int lengthInBits(Long l) {
        return 64;
    }

    @Override
    public boolean isBitSet(Long l, int n) {
        return (l & LongKeyAnalyzer.mask(n)) != 0L;
    }

    @Override
    public int bitIndex(Long l, Long l2) {
        long l3 = l;
        if (l3 == 0L) {
            return -1;
        }
        long l4 = l2;
        if (l3 != l4) {
            long l5 = l3 ^ l4;
            for (int i = 0; i < 64; ++i) {
                if ((l5 & LongKeyAnalyzer.mask(i)) == 0L) continue;
                return i;
            }
        }
        return -2;
    }

    @Override
    public boolean isPrefix(Long l, Long l2) {
        return l.equals(l2);
    }
}

