/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;

public class SymbolTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Integer> _st = new HashMap();
    private Vector<String> _ts = new Vector();
    private int _num = 0;

    public void clear() {
        this._st = new HashMap();
        this._ts = new Vector();
        this._num = 0;
    }

    public int size() {
        return this._num;
    }

    public int register(String t) {
        if (this._st.containsKey(t)) {
            return this._st.get(t);
        }
        this._st.put(t, this._num);
        this._ts.add(t);
        return this._num++;
    }

    public int lookup(String s) {
        if (this._st.containsKey(s)) {
            return this._st.get(s);
        }
        return -1;
    }

    public String lookup(int t) {
        if (t <= this._ts.size() - 1 && t >= 0) {
            return this._ts.get(t);
        }
        return null;
    }

    public String[] symbols() {
        return this._ts.toArray(new String[this.size()]);
    }

    public static void main(String[] args) {
        SymbolTable st = new SymbolTable();
        System.out.println("Size:" + st.size());
        System.out.println("Register S:" + st.register("S"));
        System.out.println("Register NP:" + st.register("NP"));
        System.out.println("Size:" + st.size());
        System.out.println("Lookup 0:" + st.lookup(0));
        System.out.println("Lookup 1:" + st.lookup(1));
        System.out.println("Lookup S:" + st.lookup("S"));
        System.out.println("Lookup NP:" + st.lookup("NP"));
        System.out.println("Lookup X:" + st.lookup("X"));
        System.out.println("Cleaning ...");
        st.clear();
        System.out.println("Size:" + st.size());
    }
}

