
(* #load "str.cmxa";; *)
(* #load "scripts/trees.ml";; *)

open Str
open String
open Trees


let imax     = (int_of_string (Sys.argv.(1)))-1 ;;
let numiters = (int_of_string (Sys.argv.(2))) ;;


type 'a binary_tree = Leaf of 'a * string * string | Branch of 'a * 'a binary_tree * 'a binary_tree
;;


(* formatting exception *)
exception WrongFormat of string
;;


let rec tuptree_of_tree = function
    ChildList(f,End) -> tuptree_of_tree f
  | ChildList(Term(sP),ChildList(t0,ChildList(t1,End))) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let uP = matched_group 4 sP in
      let dP = matched_group 5 sP in
      Branch ( (lP,cP,hP,lowercase uP,dP), tuptree_of_tree t0, tuptree_of_tree t1 )
  | ChildList(Term(sP),ChildList(Term(s),End)) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let uP = matched_group 4 sP in
      let dP = matched_group 5 sP in
      if string_match (regexp "\\(.*\\)#\\(.*\\)") s 0 then
        let p = matched_group 1 s in
        let x = matched_group 2 s in
        Leaf ( (lP,cP,hP,lowercase uP,dP), p, x )
      else raise (WrongFormat "tuptree_of_tree 2")
  | ChildList(Term(sP),r) -> raise (WrongFormat sP)
  | ChildList(_,_) -> raise (WrongFormat "no label")
  | Term(s) -> raise (WrongFormat ("term "^s))
  | _ -> raise (WrongFormat "tuptree_of_tree")
;;


let first_of_bintree = function
    Branch(f,_,_) -> f
  | Leaf  (f,_,_) -> f
;;


let hA = Hashtbl.create 1000;;
let hM = Hashtbl.create 1000;;
let hL = Hashtbl.create 1000;;
let hH = Hashtbl.create 1000;;


let default_find h k = if Hashtbl.mem h k then Hashtbl.find h k else 0.0
;;


(* put arrays of inside probabilities for each concept index at each constituent of phrase structure tree into another tree called `instree' *)
let rec instree_of_tuptree = function
    Branch((lP,cP,hP,uP,dP),t0,t1) ->
      let (l0,c0,h0,u0,d0) = first_of_bintree t0 in
      let (l1,c1,h1,u1,d1) = first_of_bintree t1 in
      let ins0 = instree_of_tuptree t0 in
      let ins1 = instree_of_tuptree t1 in
      let eP = Array.make (imax+1) 0.0 in
      for iP = 0 to imax do
        (* sum out left child *)
        let pr0 = ref 0.0 in
        for i0 = 0 to imax do
(*          pr0 := !pr0 +.  (default_find hL (l0,iP,i0)) *. (Array.get (first_of_bintree ins0) i0)*)
          pr0 := !pr0 +.  (default_find hL (u0,d0,l0,iP,i0)) *. (Array.get (first_of_bintree ins0) i0)
        done;
        (* sum out right child *)
        let pr1 = ref 0.0 in
        for i1 = 0 to imax do
(*          pr1 := !pr1 +.  (default_find hL (l1,iP,i1)) *. (Array.get (first_of_bintree ins1) i1)*)
          pr1 := !pr1 +.  (default_find hL (u1,d1,l1,iP,i1)) *. (Array.get (first_of_bintree ins1) i1)
        done;
        (* if !pr0 = 0.0 or !pr1 = 0.0 then prerr_endline ( "WARN: zero prob at "^lP^":"^cP^"{"^hP^"}^"^uP^","^dP^" -> "^l0^":"^c0^"{"^h0^"}^"^u0^","^d0^" "^l1^":"^c1^"{"^h1^"}^"^u1^","^d1 ); *)
        Array.set eP iP ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr0 *. !pr1)
(*          ; prerr_endline ("  using: "^uP^" "^dP^" "^lP^" "^cP^" "^(string_of_int iP)^" "^l0^" "^c0^" "^l1^" "^c1);*)
(*          prerr_endline ("  prob of e["^(string_of_int iP)^"] at "^cP^": "^(string_of_float (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)))^" "^(string_of_float !pr0)^" "^(string_of_float !pr1)^" "^(string_of_float (Array.get eP iP)));*)
      done;
      Branch ( eP, ins0, ins1 )
  | Leaf((lP,cP,hP,uP,dP),p,x) ->
      let l0 = "-" in
      let c0 = "-" in
      let l1 = "-" in
      let c1 = "-" in
      let eP = Array.make (imax+1) 0.0 in
      for iP = 0 to imax do
        (* fatten up probs with 10000 to avoid underflow *)
        Array.set eP iP ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hH (cP,iP,hP)) *. 1000.0)
(*          ; prerr_endline ("  prob of e["^(string_of_int i)^"] at "^c^": "^(string_of_float (Array.get e i)));*)
      done;
      Leaf ( eP, "", "" )
;;


let hAnum = Hashtbl.create 1000;;
let hMnum = Hashtbl.create 1000;;
let hLnum = Hashtbl.create 1000;;
let hHnum = Hashtbl.create 1000;;
let hAdenom = Hashtbl.create 1000;;
let hMdenom = Hashtbl.create 1000;;
let hLdenom = Hashtbl.create 1000;;
let hHdenom = Hashtbl.create 1000;;


let rec estep = function
    (tot, aP, Branch((lP,cP,hP,uP,dP),t0,t1), Branch(eP,te0,te1)) ->
      let (l0,c0,h0,u0,d0) = first_of_bintree t0 in
      let (l1,c1,h1,u1,d1) = first_of_bintree t1 in

      let ttl = ref 0.0 in
      for iP = 0 to imax do
        ttl := !ttl +. ((Array.get aP iP) *. (Array.get eP iP))
      done;

      let a0    = Array.make (imax+1) 0.0 in
      let a1    = Array.make (imax+1) 0.0 in
      let a0tot = ref 0.0 in
      let a1tot = ref 0.0 in
      for iP = 0 to imax do

        (* if ( (Array.get aP iP) = 0.0 ) then prerr_endline ( "ERROR: e"^(string_of_int iP)^" zero aP: "^uP^" "^dP^" "^lP^":"^cP^"{"^(string_of_int iP)^hP^"} -> "^l0^":"^c0^"{"^h0^"} "^l1^":"^c1^"{"^h1^"}" ); *)

        (* sum out right child *)
        let pr1 = ref 0.0 in
        for i1 = 0 to imax do
(*          pr1 := !pr1 +.  (default_find hL (l1,iP,i1)) *. (Array.get (first_of_bintree te1) i1)*)
          pr1 := !pr1 +.  (default_find hL (u1,d1,l1,iP,i1)) *. (Array.get (first_of_bintree te1) i1)
        done;
        (* sum out left child *)
        let pr0 = ref 0.0 in
        for i0 = 0 to imax do
(*          pr0 := !pr0 +.  (default_find hL (l0,iP,i0)) *. (Array.get (first_of_bintree te0) i0)*)
          pr0 := !pr0 +.  (default_find hL (u0,d0,l0,iP,i0)) *. (Array.get (first_of_bintree te0) i0)
        done;
        (*if ( pr0 = 0.0 or pr1 = 0.0 ) then prerr_endline ( "ERROR: e"^(string_of_int iP)^" zero pr0 or pr1");*)

        (* update L expected counts *)
        for i0 = 0 to imax do
          Array.set a0 i0 ( (Array.get a0 i0) +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr1 *. (default_find hL (u0,d0,l0,iP,i0))) );
          a0tot :=        ( !a0tot            +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr1 *. (default_find hL (u0,d0,l0,iP,i0))) );
          Hashtbl.replace hLnum   (u0,d0,l0,iP,i0) ((default_find hLnum   (u0,d0,l0,iP,i0)) +.
                                                      ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (u0,d0,l0,iP,i0)) *. ((Array.get aP iP) *. !pr1 *. (Array.get (first_of_bintree te0) i0) /. !ttl)) );
          Hashtbl.replace hLdenom (u0,d0,l0,iP)    ((default_find hLdenom (u0,d0,l0,iP))    +.
                                                      ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (u0,d0,l0,iP,i0)) *. ((Array.get aP iP) *. !pr1 *. (Array.get (first_of_bintree te0) i0) /. !ttl)) )
(*          Array.set a0 i0 ( (Array.get a0 i0) +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr1 *. (default_find hL (l0,iP,i0))) );*)
(*          a0tot :=        ( !a0tot            +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr1 *. (default_find hL (l0,iP,i0))) );*)
(*          Hashtbl.replace hLnum   (l0,iP,i0) ((default_find hLnum   (l0,iP,i0)) +.*)
(*                                                ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (l0,iP,i0)) *. ((Array.get aP iP) *. !pr1 *. (Array.get (first_of_bintree te0) i0) /. !ttl)) );*)
(*          Hashtbl.replace hLdenom (l0,iP)    ((default_find hLdenom (l0,iP))    +.*)
(*                                                ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (l0,iP,i0)) *. ((Array.get aP iP) *. !pr1 *. (Array.get (first_of_bintree te0) i0) /. !ttl)) )*)
        done;

        (* update L expected counts *)
        for i1 = 0 to imax do
          Array.set a1 i1 ( (Array.get a1 i1) +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr0 *. (default_find hL (u1,d1,l1,iP,i1))) );
          a1tot :=        ( !a1tot            +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr0 *. (default_find hL (u1,d1,l1,iP,i1))) );
          Hashtbl.replace hLnum   (u1,d1,l1,iP,i1) ( (default_find hLnum   (u1,d1,l1,iP,i1)) +.
                                                       ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (u1,d1,l1,iP,i1)) *. ((Array.get aP iP) *. !pr0 *. (Array.get (first_of_bintree te1) i1) /. !ttl)) );
          Hashtbl.replace hLdenom (u1,d1,l1,iP)    ( (default_find hLdenom (u1,d1,l1,iP))    +.
                                                       ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (u1,d1,l1,iP,i1)) *. ((Array.get aP iP) *. !pr0 *. (Array.get (first_of_bintree te1) i1) /. !ttl)) )
(*          Array.set a1 i1 ( (Array.get a1 i1) +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr0 *. (default_find hL (l1,iP,i1))) );*)
(*          a1tot :=        ( !a1tot            +. ((Array.get aP iP) *. (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. !pr0 *. (default_find hL (l1,iP,i1))) );*)
(*          Hashtbl.replace hLnum   (l1,iP,i1) ( (default_find hLnum   (l1,iP,i1)) +.*)
(*                                                 ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (l1,iP,i1)) *. ((Array.get aP iP) *. !pr0 *. (Array.get (first_of_bintree te1) i1) /. !ttl)) );*)
(*          Hashtbl.replace hLdenom (l1,iP)    ( (default_find hLdenom (l1,iP))    +.*)
(*                                                 ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hL (l1,iP,i1)) *. ((Array.get aP iP) *. !pr0 *. (Array.get (first_of_bintree te1) i1) /. !ttl)) )*)
        done;

        (* update M expected counts *)
        Hashtbl.replace hMnum   (uP,dP,lP,cP,iP,l0,c0,l1,c1) ( (default_find hMnum   (uP,dP,lP,cP,iP,l0,c0,l1,c1)) +.
                                                               ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. ((Array.get aP iP) *. !pr0 *. !pr1 /. !ttl)) );
        Hashtbl.replace hMdenom (uP,dP,lP,cP,iP)             ( (default_find hMdenom (uP,dP,lP,cP,iP))             +.
                                                               ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. ((Array.get aP iP) *. !pr0 *. !pr1 /. !ttl)) )
        (* ;
        if (Hashtbl.find hMdenom (uP,dP,lP,cP,iP)) = 0.0 then prerr_endline ( "WARNING: zero denominator: hMdenom "^
                                                                              (string_of_float (Array.get aP iP))^" * "^
                                                                              (string_of_float (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)))^" * "^
                                                                              (string_of_float !pr0)^" * "^
                                                                              (string_of_float !pr1)^" / "^
                                                                              (string_of_float (Array.get eP iP))^" in "^
                                                                              uP^" "^dP^" "^lP^":"^cP^"{"^(string_of_int iP)^hP^"} -> "^l0^":"^c0^"{"^h0^"} "^l1^":"^c1^"{"^h1^"}" )
        *)
      done;

      (* normalize outside probs *)
      for iC = 0 to imax do
        if !a0tot = 0.0 then prerr_endline ( "ERROR: a0tot=0.0! "^uP^" "^dP^" "^lP^":"^cP^"{"^hP^"}" );
        if !a1tot = 0.0 then prerr_endline ( "ERROR: a1tot=0.0! "^uP^" "^dP^" "^lP^":"^cP^"{"^hP^"}" );
        Array.set a0 iC ( (Array.get a0 iC) /. !a0tot );
        Array.set a1 iC ( (Array.get a1 iC) /. !a1tot )
      done;

      (* recurse down tree *)
      estep (tot, a0, t0, te0);
      estep (tot, a1, t1, te1)

  | (tot, aP, Leaf((lP,cP,hP,uP,dP),p,x), Leaf(eP,"","")) ->
      let l0 = "-" in
      let c0 = "-" in
      let l1 = "-" in
      let c1 = "-" in

      let ttl = ref 0.0 in
      for iP = 0 to imax do
        ttl := !ttl +. ((Array.get aP iP) *. (Array.get eP iP))
      done;

      (* update H expected counts *)
      for iP = 0 to imax do
        Hashtbl.replace hHnum   (cP,iP,hP) ( (default_find hHnum   (cP,iP,hP)) +.
                                             ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hH (cP,iP,hP)) *. ((Array.get aP iP) /. !ttl)) );
        Hashtbl.replace hHdenom (cP,iP)    ( (default_find hHdenom (cP,iP))    +.
                                             ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hH (cP,iP,hP)) *. ((Array.get aP iP) /. !ttl)) )
      done;

      (* update M expected counts *)
      for iP = 0 to imax do
        Hashtbl.replace hMnum   (uP,dP,lP,cP,iP,l0,c0,l1,c1) ( (default_find hMnum   (uP,dP,lP,cP,iP,l0,c0,l1,c1)) +.
                                                               ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hH (cP,iP,hP)) *. ((Array.get aP iP) /. !ttl)) );
        Hashtbl.replace hMdenom (uP,dP,lP,cP,iP)             ( (default_find hMdenom (uP,dP,lP,cP,iP))             +.
                                                               ((default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)) *. (default_find hH (cP,iP,hP)) *. ((Array.get aP iP) /. !ttl)) )
        (* ;
        if (Hashtbl.find hMdenom (uP,dP,lP,cP,iP)) = 0.0 then prerr_endline ( "WARNING: zero denominator: hMdenom "^
                                                                              (string_of_float (Array.get aP iP))^" * "^
                                                                              (string_of_float (default_find hM (uP,dP,lP,cP,iP,l0,c0,l1,c1)))^" * "^
                                                                              (string_of_float (default_find hH (cP,iP,hP)))^" / "^
                                                                              (string_of_float (Array.get eP iP)) )
        *)
      done

  | _ -> raise (WrongFormat "estep")
;;


let ltrees = ref [];;


(* read loop *)
try
  while true do
    let s = input_line stdin in
    if (string_match (regexp "^A : \\(.*\\):\\(.*\\){e\\(.*\\)} = \\(.*\\)") s 0) then
      let lP = matched_group 1 s in
      let cP = matched_group 2 s in
      let iP = matched_group 3 s in
      let pr = matched_group 4 s in
      Hashtbl.replace hA (lP,cP,(int_of_string iP)) (float_of_string pr)
    else if (string_match (regexp "^M \\(.*\\) \\(.*\\) \\(.*\\):\\(.*\\){e\\(.*\\)} : \\(.*\\):\\(.*\\) \\(.*\\):\\(.*\\) = \\(.*\\)") s 0) then
      let uP = matched_group 1 s in
      let dP = matched_group 2 s in
      let lP = matched_group 3 s in
      let cP = matched_group 4 s in
      let iP = matched_group 5 s in
      let l0 = matched_group 6 s in
      let c0 = matched_group 7 s in
      let l1 = matched_group 8 s in
      let c1 = matched_group 9 s in
      let pr = matched_group 10 s in
      Hashtbl.replace hM (lowercase uP,dP,lP,cP,(int_of_string iP),l0,c0,l1,c1) (float_of_string pr)
(*    else if (string_match (regexp "^L \\([^ ]*\\) e\\([^ ]*\\) : e\\([^ ]*\\) = \\([^ ]*\\)") s 0) then*)
(*      let lP = matched_group 1 s in*)
(*      let iP = matched_group 2 s in*)
(*      let iC = matched_group 3 s in*)
(*      let pr = matched_group 4 s in*)
(*      Hashtbl.replace hL (lP,(int_of_string iP),(int_of_string iC)) (float_of_string pr)*)
    else if (string_match (regexp "^L \\([^ ]*\\) \\([^ ]*\\) \\([^ ]*\\) e\\([^ ]*\\) : e\\([^ ]*\\) = \\([^ ]*\\)") s 0) then
      let uC = matched_group 1 s in
      let dC = matched_group 2 s in
      let lP = matched_group 3 s in
      let iP = matched_group 4 s in
      let iC = matched_group 5 s in
      let pr = matched_group 6 s in
      Hashtbl.replace hL (uC,dC,lP,(int_of_string iP),(int_of_string iC)) (float_of_string pr)
    else if (string_match (regexp "^H \\([^ ]*\\) e\\([^ ]*\\) : \\([^ ]*\\) = \\([^ ]*\\)") s 0) then
      let c = matched_group 1 s in
      let i = matched_group 2 s in
      let h = matched_group 3 s in
      let pr = matched_group 4 s in
      Hashtbl.replace hH (c,(int_of_string i),h) (float_of_string pr)
    else (
      (* prerr_endline ("assuming tree: "^s); *)
      let r,t = tree_of_string s in
      ltrees := (tuptree_of_tree t) :: !ltrees
    )
  done;
  None
with
  End_of_file -> None
;;


let aP = Array.make (imax+1) 0.0
;;


(* iterate EM *)
for iter = 1 to numiters do
  prerr_endline ("EM iteration "^(string_of_int iter)^"...");

  (* E step *)
  prerr_endline("E step...");
  Hashtbl.clear hMnum;
  Hashtbl.clear hLnum;
  Hashtbl.clear hHnum;
  Hashtbl.clear hMdenom;
  Hashtbl.clear hLdenom;
  Hashtbl.clear hHdenom;
  let corptot = ref 0.0 in
  let maxtreeprob = ref neg_infinity in
  let mintreeprob = ref infinity in
  List.iter (function t ->
    (*print_endline ("tree...");*)
    let ins = instree_of_tuptree t in
    let eP  = first_of_bintree ins in
    let (lP,cP,hP,uP,dP) = first_of_bintree t in
    for iP = 0 to imax do
      (Array.set aP iP (default_find hA (lP,cP,iP)))
    done;
    let tot = ref 0.0 in
    for iP = 0 to imax do
      tot := !tot +. ((Array.get aP iP) *. (Array.get eP iP))
    done;
    (* prerr_endline ("prob of tree: "^(string_of_float !tot)); *)
    if !tot <> 0.0 then corptot := !corptot +. (log !tot)
    else prerr_endline ("ERROR: prob of tree = zero!")
    ;
    if !tot > !maxtreeprob then maxtreeprob := !tot;
    if !tot < !mintreeprob then mintreeprob := !tot;
    estep (tot, aP, t, ins);
    (* update A num *)
    for iP = 0 to imax do
      Hashtbl.replace hAnum   (lP,cP,iP) ( (default_find hAnum   (lP,cP,iP)) +.
                                           if !tot = 0.0 then 0.0 else
                                           ((Array.get aP iP) *. (Array.get eP iP) /. !tot) );
      Hashtbl.replace hAdenom ()         ( (default_find hAdenom ()        ) +.
                                           if !tot = 0.0 then 0.0 else
                                           ((Array.get aP iP) *. (Array.get eP iP) /. !tot) )
    done
  ) !ltrees;
  prerr_endline("LOG PROB OF CORPUS : "^(string_of_float !corptot));
  prerr_endline("MAX TREE PROB : "^(string_of_float !maxtreeprob));
  prerr_endline("MIN TREE PROB : "^(string_of_float !mintreeprob));

  (* M step *)
  prerr_endline("M step...");
  Hashtbl.clear hA;
  Hashtbl.iter (fun (lP,cP,iP) pr ->
    let prDenom = (default_find hAdenom ()) in
    if (pr <> 0.0) then ( Hashtbl.add hA (lP,cP,iP) (pr /. prDenom);
                          prerr_endline ("A : "^lP^":"^cP^"{e"^(string_of_int iP)^"} = "^(string_of_float (pr /. prDenom)))
                         )
  ) hAnum;
  Hashtbl.clear hM;
  Hashtbl.iter (fun (uP,dP,lP,cP,iP,l0,c0,l1,c1) pr ->
    (*prerr_endline("M "^uP^" "^dP^" "^lP^":"^cP^"{e"^(string_of_int iP)^"} : "^l0^":"^c0^" "^l1^":"^c1^" = "^(string_of_float pr)^"/"^(string_of_float (default_find hMdenom (uP,dP,lP,cP,iP))));*)
    let prDenom = (default_find hMdenom (uP,dP,lP,cP,iP)) in
    if (pr <> 0.0) then ( Hashtbl.add hM (uP,dP,lP,cP,iP,l0,c0,l1,c1) (pr /. prDenom);
                          prerr_endline ("M "^uP^" "^dP^" "^lP^":"^cP^"{e"^(string_of_int iP)^"} : "^l0^":"^c0^" "^l1^":"^c1^" = "^(string_of_float (pr /. prDenom)))
                         )
  ) hMnum;
(*  Hashtbl.clear hL;*)
(*  Hashtbl.iter (fun (lC,iP,iC) pr ->*)
(*    (*prerr_endline("L "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float pr)^"/"^(string_of_float (default_find hLdenom (lC,iP))));*)*)
(*    let prDenom = (default_find hLdenom (lC,iP)) in*)
(*    if (pr <> 0.0) then ( Hashtbl.add hL (lC,iP,iC) (pr /. prDenom);*)
(*                          prerr_endline ("L "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float (pr /. prDenom)))*)
(*                         )*)
(*  ) hLnum;*)
  Hashtbl.clear hL;
  Hashtbl.iter (fun (uC,dC,lC,iP,iC) pr ->
    (*prerr_endline("L "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float pr)^"/"^(string_of_float (default_find hLdenom (lC,iP))));*)
    let prDenom = (default_find hLdenom (uC,dC,lC,iP)) in
    if (pr <> 0.0) then ( Hashtbl.add hL (uC,dC,lC,iP,iC) (pr /. prDenom);
                          prerr_endline ("L "^uC^" "^dC^" "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float (pr /. prDenom)))
                         )
  ) hLnum;
  Hashtbl.clear hH;
  Hashtbl.iter (fun (c,i,h) pr ->
    (*prerr_endline("H "^c^" e"^(string_of_int i)^" : "^h^" = "^(string_of_float pr)^"/"^(string_of_float (default_find hHdenom (c,i))));*)
    let prDenom = (default_find hHdenom (c,i)) in
    if (pr <> 0.0) then ( Hashtbl.add hH (c,i,h) (pr /. prDenom);
                          prerr_endline ("H "^c^" e"^(string_of_int i)^" : "^h^" = "^(string_of_float (pr /. prDenom)))
                         )
  ) hHnum;

done
;;


(* write loop *)
Hashtbl.iter (fun (lP,cP,iP) pr ->
  print_endline ("A : "^lP^":"^cP^"{e"^(string_of_int iP)^"} = "^(string_of_float pr))
) hA;
Hashtbl.iter (fun (uP,dP,lP,cP,iP,l0,c0,l1,c1) pr ->
  print_endline ("M "^uP^" "^dP^" "^lP^":"^cP^"{e"^(string_of_int iP)^"} : "^l0^":"^c0^" "^l1^":"^c1^" = "^(string_of_float pr))
) hM;
(* Hashtbl.iter (fun (lC,iP,iC) pr ->*)
(*   print_endline ("L "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float pr))*)
(* ) hL;*)
 Hashtbl.iter (fun (uC,dC,lC,iP,iC) pr ->
   print_endline ("L "^uC^" "^dC^" "^lC^" e"^(string_of_int iP)^" : e"^(string_of_int iC)^" = "^(string_of_float pr))
 ) hL;
Hashtbl.iter (fun (c,i,h) pr ->
  print_endline ("H "^c^" e"^(string_of_int i)^" : "^h^" = "^(string_of_float pr))
) hH
;;
