#!/usr/bin/env bash

# setup the environment
#echo Setup the environment ...
set -e  # exit if error

# prepare folders
exp_path=exp_Open_source_model
data_path=$exp_path/data
res_path=$exp_path/results
mkdir -p $exp_path $data_path $res_path

datasets="xsum squad writing"
source_models="gpt2-xl gpt-j-6B gpt-neo-2.7B opt-2.7b gpt-neox-20b"


# White-box Setting
echo Evaluate models in the white-box setting:

echo `date`,evaluate Fast-DetectGPT and fast baselines
for D in $datasets; do
  for M in $source_models; do
    echo `date`, Evaluating Fast-DetectGPT on ${D}_${M} ............
    python ./TOCSIN.py --reference_model_name $M --scoring_model_name $M --dataset $D \
                          --dataset_file $data_path/${D}_${M} --output_file $res_path/${D}_${M}
  done
done

# Black-box Setting
echo `date`, Evaluate models in the black-box setting:
scoring_models="gpt-neo-2.7B"

# evaluate Fast-DetectGPT
for D in $datasets; do
  for M in $source_models; do
    M1=gpt-j-6B  # sampling model
   for M2 in $scoring_models; do
      echo `date`, Evaluating Fast-DetectGPT on ${D}_${M}.${M1}_${M2} ...
      python ./TOCSIN.py --reference_model_name ${M1} --scoring_model_name ${M2} --dataset $D \
                          --dataset_file $data_path/${D}_${M} --output_file $res_path/${D}_${M}.${M1}_${M2}
    done
  done
done
