#!/bin/bash

ce_weight=0.4

for random_seed in $(seq 1 10);
do
    for n_att_n_comb_n_dup in \
        "[(1, 4, 1)]" 
    do
        for group_size in 4 2 1;
        do
            python EGG/egg/zoo/compo_vs_generalization/train.py  \
                --n_values=10 \
                --n_attributes=4 \
                --vocab_size=10 \
                --max_len=5 \
                --batch_size=5120 \
                --sender_cell=gru \
                --sender_emb=5 \
                --sender_hidden=500 \
                --sender_entropy_coeff=0.5 \
                --receiver_cell=gru \
                --receiver_emb=30 \
                --receiver_hidden=500 \
                --n_epoch=50 \
                --random_seed $random_seed \
                --wandb_project=div_int \
                --wandb_name "g_${group_size}_c${ce_weight}_${n_att_n_comb_n_dup}" \
                --lr 0.001 \
                --data_scaler=60 \
                --n_att_n_comb_n_dup "$n_att_n_comb_n_dup" \
                --wandb_tags "[both_v1]" \
                --early_stopping_thr 0.99 \
                --validation_freq=1 \
                --stats_freq=1 \
                --val_eval_freq 1 \
                --test_eval_freq 1 \
                --validation_ratio 0.0 \
                --test_ratio 0.1 \
                --topsim_max_samples 3000 \
                --eol_n_epoch 6 \
                --eol_early_stopping_thr 2.99 \
                --load_val_best false \
                --cross_entropy_weight $ce_weight \
                --preserve_eos true \
                --metric_exclude_eos true \
                --group_size $group_size \
                --loss_type mixed
        done 
    done 
done 