root=./

MODEL_SUFFIX=$1
SUBSET=$2
tag=$3
gen_subsets="train valid test"
if ! [[ "${gen_subsets}" =~ "${SUBSET}" ]]
then
    SUBSET=test
fi
echo $SUBSET
model_signature=${MODEL_SUFFIX}
log_signature=${MODEL_SUFFIX}_${SUBSET}

echo wmt14_en_de/${log_signature}

export CUDA_VISIBLE_DEVICES=0
python ${root}/fairseq_cli/my_generate.py \
    ${root}/data-bin/wmt14_en_de \
    --source-lang en --target-lang de \
    --task my_translation \
    --mode at \
    --path ${root}/checkpoints/wmt14_en_de/${model_signature}/${tag}.pt \
    --beam 5 \
    --gen-subset ${SUBSET} \
    --results-path ${root}/log/at/wmt14_en_de/logging_${log_signature} \
    --my-results-path ${root}/output/at_output/wmt14_en_de/temp_${log_signature}.txt

${root}/scripts/eval_test.sh ${log_signature} wmt14_en_de de