/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.realiser.NPPhraseSpec;

public class Contraction {
    public static final boolean isObligatoryPrepContraction(Preposition p, NPPhraseSpec np) {
        Object o = np.getSpecifier();
        if (o == null || !(o instanceof Determiner)) {
            return false;
        }
        String det = ((Determiner)o).getForm(np.getCase(), np.getNumber(), np.getGender());
        String prep = p.getLeftForm();
        if (det.equals("dem")) {
            return prep.equals("an") || prep.equals("bei") || prep.equals("in") || prep.equals("von") || prep.equals("zu");
        }
        if (det.equals("das")) {
            return prep.equals("an") || prep.equals("in");
        }
        if (det.equals("der")) {
            return prep.equals("zu");
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isPossiblePrepContraction(Preposition p, NPPhraseSpec np) {
        String form;
        Object o = np.getSpecifier();
        if (o == null) {
            return false;
        }
        if (o instanceof Determiner) {
            if (!((Determiner)o).getBaseForm().equals("der")) return false;
            form = ((Determiner)o).getForm(np.getCase(), np.getNumber(), np.getGender());
        } else {
            if (!(o instanceof Pronoun)) return false;
            if (!((Pronoun)o).getBaseForm().equals("derselbe")) return false;
            form = ((Pronoun)o).getForm(np.getCase(), np.getNumber(), np.getGender());
        }
        String prep = p.getLeftForm();
        if (form.equals("dem") || form.equals("demselben")) {
            if (prep.equals("an")) return true;
            if (prep.equals("bei")) return true;
            if (prep.equals("in")) return true;
            if (prep.equals("von")) return true;
            if (prep.equals("zu")) return true;
            if (prep.equals("hinter")) return true;
            if (prep.equals("\u00fcber")) return true;
            if (prep.equals("unter")) return true;
            if (!prep.equals("vor")) return false;
            return true;
        }
        if (form.equals("das") || form.equals("dasselbe")) {
            if (prep.equals("an")) return true;
            if (prep.equals("in")) return true;
            if (prep.equals("auf")) return true;
            if (prep.equals("durch")) return true;
            if (prep.equals("f\u00fcr")) return true;
            if (prep.equals("hinter")) return true;
            if (prep.equals("\u00fcber")) return true;
            if (prep.equals("um")) return true;
            if (prep.equals("unter")) return true;
            if (!prep.equals("vor")) return false;
            return true;
        }
        if (form.equals("der")) return prep.equals("zu");
        if (form.equals("derselbe")) {
            return prep.equals("zu");
        }
        if (!form.equals("den")) {
            if (!form.equals("denselben")) return false;
        }
        if (prep.equals("hinter")) return true;
        if (prep.equals("\u00fcber")) return true;
        if (!prep.equals("unter")) return false;
        return true;
    }

    public static final String makePrepContraction(Preposition p, NPPhraseSpec np) {
        Object o = np.getSpecifier();
        if (o == null || !(o instanceof Determiner)) {
            return "";
        }
        String det = ((Determiner)o).getForm(np.getCase(), np.getNumber(), np.getGender());
        String prep = p.getLeftForm();
        if (det.equals("dem") && prep.endsWith("n")) {
            prep = prep.substring(0, prep.length() - 1);
        }
        return prep.concat(det.substring(det.length() - 1));
    }
}

