--[[
This module will transliterate Abkhaz language text per WT:AB TR.
Transliteration for Abkhaz.
]]
local export = {}

local tt = {
	['А'] = 'Ā', ['а'] = 'ā', ['Б'] = 'B', ['б'] = 'b', ['В'] = 'V', ['в'] = 'v', ['Г'] = 'G', ['г'] = 'g',
	['Ӷ'] = 'Γ', ['ӷ'] = 'γ', ['Д'] = 'D', ['д'] = 'd', ['Џ'] = 'Ǯ', ['џ'] = 'ǯ', ['Е'] = 'E', ['е'] = 'e',
	['Ҽ'] = 'Č', ['ҽ'] = 'č', ['Ҿ'] = 'Č̣', ['ҿ'] = 'č̣', ['Ж'] = 'Ž', ['ж'] = 'ž', ['З'] = 'Z', ['з'] = 'z',
	['Ӡ'] = 'Ʒ', ['ӡ'] = 'ʒ', ['И'] = 'I', ['и'] = 'i', ['К'] = 'Ḳ', ['к'] = 'ḳ', ['Қ'] = 'K', ['қ'] = 'k',
	['Ҟ'] = 'Q̇', ['ҟ'] = 'q̇', ['Л'] = 'L', ['л'] = 'l', ['М'] = 'M', ['м'] = 'm', ['Н'] = 'N', ['н'] = 'n',
	['О'] = 'O', ['о'] = 'o', ['Ҩ'] = 'ʿ°', ['ҩ'] = 'ʿ°', ['П'] = 'Ṗ', ['п'] = 'ṗ', ['Ԥ'] = 'P', ['ԥ'] = 'p',
	['Р'] = 'R', ['р'] = 'r', ['С'] = 'S', ['с'] = 's', ['Т'] = 'Ṭ', ['т'] = 'ṭ', ['Ҭ'] = 'T', ['ҭ'] = 't',
	['У'] = 'U', ['у'] = 'u', ['Ф'] = 'F', ['ф'] = 'f', ['Х'] = 'X', ['х'] = 'x', ['Ҳ'] = 'Ḥ', ['ҳ'] = 'ḥ',
	['Ц'] = 'C', ['ц'] = 'c', ['Ҵ'] = 'C̣', ['ҵ'] = 'c̣', ['Ч'] = 'Č̍', ['ч'] = 'č̍', ['Ҷ'] = 'Č̣̍', ['ҷ'] = 'č̣̍',
	['Ш'] = 'Š', ['ш'] = 'š', ['Ы'] = 'Ə', ['ы'] = 'ə', ['Ь'] = '’', ['ь'] = '’', ['Ә'] = 'W', ['ә'] = 'w', ['́'] = '́',
	-- obsolete letters, still in use
	['Ҕ'] = 'Γ', ['ҕ'] = 'γ', ['Ҧ'] = 'P', ['ҧ'] = 'p',
	-- in borrowings from Russian and other languages
	['Ё'] = 'Ë', ['ё'] = 'ë', ['Й'] = 'J', ['й'] = 'j', ['Ъ'] = 'ʺ', ['ъ'] = 'ʺ', ['Э'] = 'È', ['э'] = 'è',
	['Ю'] = 'Ju', ['ю'] = 'ju', ['Я'] = 'Ja', ['я'] = 'ja',

	-- two letter mapping
	['дә'] = 'd°', ['Дә'] = 'D°', ['ҭә'] = 't°', ['Ҭә'] = 'T°', ['тә'] = 'ṭ°', ['Тә'] = 'Ṭ°',
	['ӡә'] = 'ʒ°', ['Ӡә'] = 'Ʒ°', ['цә'] = 'c°', ['Цә'] = 'C°', ['ҵә'] = 'c̣°', ['Ҵә'] = 'C̣°',
	['џь'] = 'ǯ̍', ['Џь'] = 'Ǯ̍', ['жь'] = 'ž̍', ['Жь'] = 'Ž̍', ['шь'] = 'š̍', ['Шь'] = 'Š̍',
	['жә'] = 'ž°', ['Жә'] = 'Ž°', ['шә'] = 'š°', ['Шә'] = 'Š°', ['гь'] = 'g̍', ['Гь'] = 'G̍',
	['қь'] = 'k̍', ['Қь'] = 'K̍', ['кь'] = 'ḳ̍', ['Кь'] = 'Ḳ̍', ['ҕь'] = 'γ̍', ['Ҕь'] = 'Γ̍',
	['ӷь'] = 'γ̍', ['Ӷь'] = 'Γ̍', ['хь'] = 'x̍', ['Хь'] = 'X̍', ['гу'] = 'g°', ['Гу'] = 'G°',
	['қу'] = 'k°', ['Қу'] = 'K°', ['ку'] = 'ḳ°', ['Ку'] = 'Ḳ°', ['ҕу'] = 'γ°', ['Ҕу'] = 'Γ°',
	['ӷу'] = 'γ°', ['Ӷу'] = 'Γ°', ['ху'] = 'x°', ['Ху'] = 'X°', ['ҟь'] = 'q̇̍', ['Ҟь'] = 'Q̇̍',
	['ҟу'] = 'q̇°', ['Ҟу'] = 'Q̇°̍', ['ҳу'] = 'h°̍', ['Ҳу'] = 'H°',
	['гә'] = 'g°', ['Гә'] = 'G°', ['қә'] = 'k°', ['Қә'] = 'K°', ['кә'] = 'ḳ°', ['Кә'] = 'Ḳ°',
	['ҕә'] = 'γ°', ['Ҕә'] = 'Γ°', ['ӷә'] = 'γ°', ['Ӷә'] = 'Γ°', ['хә'] = 'x°', ['Хә'] = 'X°',
	['ҟә'] = 'q̇°', ['Ҟә'] = 'Q̇°̍', ['ҳә'] = 'h°̍', ['Ҳә'] = 'H°'
};

function export.tr(text, lang, sc)
	-- If the script is given as Geor, then forward the transliteration to that module
	if sc == "Geor" then
		return require("Module:Geor-translit").tr(text, lang, sc)
	end
	text = mw.ustring.gsub(text, '[гГӷӶҕҔдДжЖӡӠкКқҚҟҞтТҭҬҵҴхХҳҲцЦџЏшШ].', tt)
	text = mw.ustring.gsub(text, '.', tt)
	
	return text
end

return export