#ifndef _WEIGHT_BASE_H
#define _WEIGHT_BASE_H

#include <string>
#include <iostream>

class WeightBase {
public:

protected:
    std::string input_file_;
    std::string output_file_;

    virtual void loadScores(std::istream& is) = 0;
    virtual void saveScores(std::ostream& os) const = 0;

public:
    WeightBase(const std::string& input_file,
               const std::string& output_file)
    : input_file_(input_file), output_file_(output_file) {}

    virtual ~WeightBase(){};

    void loadScores();
    void saveScores();
    virtual void computeAverageFeatureWeights(const int& round) = 0;
};

#endif

// Local Variables:
// mode: c++
// End:
