/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.CCGInternalNode;
import LinguaView.syntax.CCGTerminalNode;
import LinguaView.syntax.CategoryObject;
import LinguaView.syntax.ParenthesesBlockCCG;
import SyntaxUtils.CCGChart;
import SyntaxUtils.CCGParseResult;
import fig.basic.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public abstract class CCGNode {
    public static boolean HIDE_ADJUNCT_ARGUMENT = false;
    @Deprecated
    protected CCGInternalNode parent;
    public String parString;
    public String source = null;
    public String additionalInfo = null;
    CategoryObject cat;
    protected int start;
    protected int end;
    Map<Pair<Integer, Integer>, Set<Integer>> newlyFilledSlots;
    Map<CategoryObject.CoindexedObject, Set<Pair<Integer, Integer>>> unfilledSlots;
    public Set<Integer>[][] slots;

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public String getSource() {
        if (this.source == null) {
            return null;
        }
        String[] ss = this.source.split("\\s");
        ss = ss[0].split("=");
        return ss[1];
    }

    public abstract boolean isTerminal();

    public abstract String toTreeString();

    public abstract String toIndentedTreeString(int var1);

    public String toIndentedTreeString() {
        return this.toIndentedTreeString(0);
    }

    public static CCGNode getCCGNodeFromString(String parString) {
        return CCGNode.getCCGNodeFromString(parString, null);
    }

    public static CCGNode getCCGNodeFromString(String parString, String source) {
        ParenthesesBlockCCG p = ParenthesesBlockCCG.getParenthesesBlocks(parString);
        CCGNode c = CCGNode.getCCGNodeFromParenthesesBlockCCG(p, source);
        c.parString = parString;
        return c;
    }

    public static CCGNode getCCGNodeFromParenthesesBlockCCG(ParenthesesBlockCCG p, String source) {
        return CCGNode.getCCGNodeFromParenthesesBlockCCG(p, -1, source);
    }

    private static CCGNode getCCGNodeFromParenthesesBlockCCG(ParenthesesBlockCCG p, int terminals, String source) {
        if (p.subBlocks.isEmpty()) {
            return new CCGTerminalNode(p.label.trim(), terminals + 1);
        }
        CCGInternalNode intNode = new CCGInternalNode(p.label);
        intNode.start = terminals + 1;
        int i = 0;
        int end = terminals;
        for (ParenthesesBlockCCG subP : p.subBlocks) {
            CCGInternalNode test;
            CCGNode d = CCGNode.getCCGNodeFromParenthesesBlockCCG(subP, end, source);
            end = d.end;
            intNode.children[i] = d instanceof CCGInternalNode ? ((test = (CCGInternalNode)d).prole() == 1 && test.categoryToString().equals(test.children[0].categoryToString()) ? test.children[0] : d) : d;
            d.parent = intNode;
            d.source = source;
            ++i;
        }
        intNode.end = end;
        intNode.source = source;
        return intNode;
    }

    @Deprecated
    public static ArrayList<CCGNode> readCCGFile(File inputFile, String encoding) {
        ArrayList<CCGNode> result = new ArrayList<CCGNode>();
        BufferedReader br = null;
        String cache = null;
        int count = 0;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), encoding));
            String s = br.readLine();
            while (s != null) {
                if ((s = s.trim()).length() == 0) {
                    s = br.readLine();
                    continue;
                }
                if (s.charAt(0) != '(') {
                    cache = s;
                    s = br.readLine();
                    continue;
                }
                CCGNode c = CCGNode.getCCGNodeFromString(s, cache);
                c.source = cache;
                cache = null;
                result.add(c);
                if (++count % 100 == 0) {
                    System.out.print('.');
                }
                s = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return result;
    }

    @Deprecated
    public CCGInternalNode parent() {
        return this.parent;
    }

    public abstract CCGTerminalNode headTerm();

    public String categoryToString() {
        return this.cat.toString();
    }

    public String categoryWithNoFeature() {
        return this.cat.toStringWithoutFeature();
    }

    public CategoryObject category() {
        return this.cat;
    }

    public boolean isConjunct() {
        return this.cat._isConjunctConstituent;
    }

    @Deprecated
    public boolean isUniqueDaughter() {
        return this.parent.numOfChildren == 1;
    }

    public int countAllNodes() {
        int result = 1;
        if (this.isTerminal()) {
            return result;
        }
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            result += n3.countAllNodes();
            ++n2;
        }
        return result;
    }

    public int countTerminalNodes() {
        int result = 0;
        if (this.isTerminal()) {
            return 1;
        }
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            result += n3.countTerminalNodes();
            ++n2;
        }
        return result;
    }

    public List<CCGTerminalNode> collectTerminalNodes() {
        ArrayList<CCGTerminalNode> result = new ArrayList<CCGTerminalNode>();
        this.collectTerminalNodes(result);
        return result;
    }

    private void collectTerminalNodes(List<CCGTerminalNode> terminals) {
        if (this.isTerminal()) {
            terminals.add((CCGTerminalNode)this);
            return;
        }
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            n3.collectTerminalNodes(terminals);
            ++n2;
        }
    }

    public ArrayList<CCGInternalNode> collectNonTerminalNodes() {
        ArrayList<CCGInternalNode> result = new ArrayList<CCGInternalNode>();
        this.collectNonTerminalNodes(result);
        return result;
    }

    private void collectNonTerminalNodes(List<CCGInternalNode> nonTerminals) {
        if (this.isTerminal()) {
            return;
        }
        nonTerminals.add((CCGInternalNode)this);
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            n3.collectNonTerminalNodes(nonTerminals);
            ++n2;
        }
    }

    public List<CCGNode> collectAllNodes() {
        ArrayList<CCGNode> list = new ArrayList<CCGNode>();
        this.collectAllNodes(list);
        return list;
    }

    private void collectAllNodes(List<CCGNode> list) {
        list.add(this);
        if (this.isTerminal()) {
            return;
        }
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            n3.collectAllNodes(list);
            ++n2;
        }
    }

    public ArrayList<CCGInternalNode> collectConjNodes() {
        ArrayList<CCGInternalNode> list = new ArrayList<CCGInternalNode>();
        this.collectConjNodes(list);
        return list;
    }

    private void collectConjNodes(ArrayList<CCGInternalNode> list) {
        if (this.cat._isConjunctConstituent) {
            list.add((CCGInternalNode)this);
        }
        if (this.isTerminal()) {
            return;
        }
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            CCGNode n3 = cCGNodeArray[n2];
            n3.collectConjNodes(list);
            ++n2;
        }
    }

    public int maxDepth() {
        if (this.isTerminal()) {
            return 0;
        }
        int maxDepth = 0;
        CCGNode[] cCGNodeArray = ((CCGInternalNode)this).children;
        int n = ((CCGInternalNode)this).children.length;
        int n2 = 0;
        while (n2 < n) {
            int increase = 1;
            CCGNode n3 = cCGNodeArray[n2];
            int depth = increase + n3.maxDepth();
            if (depth > maxDepth) {
                maxDepth = depth;
            }
            ++n2;
        }
        return maxDepth;
    }

    @Deprecated
    public int height() {
        int height = 0;
        CCGNode n = this;
        while (n.parent != null) {
            n = n.parent;
            ++height;
        }
        return height;
    }

    @Deprecated
    public boolean isHead() {
        return this.parent != null && this == this.parent.children[this.parent.headChild];
    }

    @Deprecated
    public boolean isRoot() {
        return this.parent == null;
    }

    public void updateParent() {
        if (this instanceof CCGTerminalNode) {
            return;
        }
        Stack<CCGInternalNode> parents = new Stack<CCGInternalNode>();
        parents.push((CCGInternalNode)this);
        while (parents.size() > 0) {
            CCGInternalNode next = (CCGInternalNode)parents.pop();
            int i = 0;
            while (i < next.numOfChildren) {
                if (next.children[i] != null) {
                    next.children[i].parent = next;
                    if (next.children[i] instanceof CCGInternalNode) {
                        parents.push((CCGInternalNode)next.children[i]);
                    }
                }
                ++i;
            }
        }
    }

    public static String toMSTUlab(CCGNode node) {
        node.updateParent();
        String words = "";
        String poss = "";
        String cat = "";
        String indexes = "";
        List<CCGTerminalNode> terminals = node.collectTerminalNodes();
        if (terminals.size() == 1) {
            CCGTerminalNode n = terminals.get(0);
            words = n.word;
            poss = n.orig_POS;
            cat = n.cat.toString();
            indexes = "0";
        } else {
            for (CCGTerminalNode leaf : terminals) {
                String dependentCat = leaf.cat.toString();
                words = String.valueOf(words) + leaf.word + "\t";
                poss = String.valueOf(poss) + leaf.orig_POS + "\t";
                cat = String.valueOf(cat) + dependentCat + "\t";
                CCGInternalNode ancestor = leaf.parent;
                if (leaf.isHead()) {
                    while (ancestor.isHead() && !ancestor.isRoot()) {
                        ancestor = ancestor.parent;
                    }
                    if (ancestor.isRoot()) {
                        indexes = String.valueOf(indexes) + "0\t";
                        continue;
                    }
                    ancestor = ancestor.parent;
                }
                CCGTerminalNode head = ancestor.getAnchorThroughPercolation();
                int indexHead = terminals.indexOf(head) + 1;
                indexes = String.valueOf(indexes) + indexHead + "\t";
            }
        }
        String result = "";
        String[] resultArray = new String[]{words, poss, cat, indexes};
        int i = 0;
        while (i < resultArray.length) {
            result = String.valueOf(result) + resultArray[i].trim() + "\n";
            ++i;
        }
        return result;
    }

    public static String toCoNLL(CCGNode node) {
        node.updateParent();
        StringBuffer result = new StringBuffer();
        List<CCGTerminalNode> terminals = node.collectTerminalNodes();
        if (terminals.size() == 1) {
            CCGTerminalNode n = terminals.get(0);
            result.append("1\t");
            result.append(String.valueOf(n.word) + "\t");
            result.append(String.valueOf(n.word) + "\t");
            result.append(String.valueOf(n.orig_POS) + "\t");
            result.append(String.valueOf(n.orig_POS) + "\t");
            result.append("_\t");
            result.append("0\t");
            result.append(String.valueOf(n.cat.toString()) + "\n");
        } else {
            int i = 0;
            for (CCGTerminalNode leaf : terminals) {
                ++i;
                CCGInternalNode ancestor = leaf.parent;
                int indexHead = -1;
                if (leaf.isHead()) {
                    while (ancestor.isHead() && !ancestor.isRoot()) {
                        ancestor = ancestor.parent;
                    }
                    if (ancestor.isRoot()) {
                        indexHead = 0;
                    } else {
                        ancestor = ancestor.parent;
                    }
                }
                if (indexHead == -1) {
                    CCGTerminalNode head = ancestor.getAnchorThroughPercolation();
                    indexHead = terminals.indexOf(head) + 1;
                }
                result.append(String.valueOf(i) + "\t");
                result.append(String.valueOf(leaf.word) + "\t");
                result.append(String.valueOf(leaf.word) + "\t");
                result.append(String.valueOf(leaf.orig_POS) + "\t");
                result.append(String.valueOf(leaf.orig_POS) + "\t");
                result.append("_\t");
                result.append(String.valueOf(indexHead) + "\t");
                result.append(String.valueOf(leaf.cat.toString()) + "\n");
            }
        }
        return result.toString();
    }

    public static void toMSTUlab(File inputFile, File outputFile, String encoding) {
        ArrayList<CCGNode> treebank = CCGNode.readCCGFile(inputFile, encoding);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(outputFile, encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        for (CCGNode n : treebank) {
            pw.println(CCGNode.toMSTUlab(n));
        }
        pw.close();
    }

    public static void toCoNLL(File inputFile, File outputFile, String encoding) {
        ArrayList<CCGNode> treebank = CCGNode.readCCGFile(inputFile, encoding);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(outputFile, encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        for (CCGNode n : treebank) {
            pw.println(CCGNode.toCoNLL(n));
        }
        pw.close();
    }

    public static void toCoNLL08(File inputFile, File outputFile, String encoding) {
        ArrayList<CCGNode> treebank = CCGNode.readCCGFile(inputFile, encoding);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(outputFile, encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        for (CCGNode n : treebank) {
            pw.println(CCGNode.toCoNLL08(n));
        }
        pw.close();
    }

    public static String toCoNLL08(CCGNode cn) {
        StringBuffer sb = new StringBuffer();
        cn.updateParent();
        ArrayList<Integer> hasArgColumns = new ArrayList<Integer>();
        if (cn.slots == null) {
            cn.slots = new Set[0][0];
        }
        int i = 0;
        while (i < cn.slots.length) {
            if (cn.slots[i] != null) {
                int j = 0;
                while (j < cn.slots[i].length) {
                    if (cn.slots[i][j] != null && cn.slots[i][j].size() > 0) {
                        hasArgColumns.add(i);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        List<CCGTerminalNode> terminals = cn.collectTerminalNodes();
        if (terminals.size() == 1) {
            CCGTerminalNode n = terminals.get(0);
            sb.append("1\t");
            sb.append(String.valueOf(n.word) + "\t");
            sb.append(String.valueOf(n.word) + "\t");
            sb.append(String.valueOf(n.orig_POS) + "\t");
            sb.append(String.valueOf(n.mod_POS) + "\t");
            sb.append(String.valueOf(n.word) + "\t");
            sb.append(String.valueOf(n.word) + "\t");
            sb.append(String.valueOf(n.categoryToString()) + "\t");
            sb.append("_\t");
            sb.append("0\t");
        } else {
            int i2 = 0;
            for (CCGTerminalNode leaf : terminals) {
                CCGInternalNode ancestor = leaf.parent;
                int indexHead = -1;
                if (leaf.isHead()) {
                    while (ancestor.isHead() && !ancestor.isRoot()) {
                        ancestor = ancestor.parent;
                    }
                    if (ancestor.isRoot()) {
                        indexHead = 0;
                    } else {
                        ancestor = ancestor.parent;
                    }
                }
                if (indexHead == -1) {
                    CCGTerminalNode head = ancestor.getAnchorThroughPercolation();
                    indexHead = terminals.indexOf(head) + 1;
                }
                sb.append(String.valueOf(i2 + 1) + "\t");
                sb.append(String.valueOf(leaf.word) + "\t");
                sb.append(String.valueOf(leaf.word) + "\t");
                sb.append(String.valueOf(leaf.orig_POS) + "\t");
                sb.append(String.valueOf(leaf.mod_POS) + "\t");
                sb.append(String.valueOf(leaf.word) + "\t");
                sb.append(String.valueOf(leaf.word) + "\t");
                sb.append(String.valueOf(leaf.cat.toString()) + "\t");
                sb.append(String.valueOf(indexHead) + "\t");
                sb.append("_\t");
                if (hasArgColumns.contains(i2)) {
                    sb.append(leaf.word);
                } else {
                    sb.append("_");
                }
                int j = 0;
                while (j < hasArgColumns.size()) {
                    int pred = (Integer)hasArgColumns.get(j);
                    if (pred == i2) {
                        sb.append("\t_");
                    } else {
                        ArrayList<Integer> ordOfSlots = new ArrayList<Integer>();
                        int k = 0;
                        while (k < cn.slots[pred].length) {
                            if (cn.slots[pred][k] != null && cn.slots[pred][k].contains(i2)) {
                                ordOfSlots.add(k + 1);
                            }
                            ++k;
                        }
                        if (ordOfSlots.size() == 0) {
                            sb.append("\t_");
                        } else {
                            sb.append("\t" + ordOfSlots.get(0));
                            k = 1;
                            while (k < ordOfSlots.size()) {
                                sb.append("\t" + ordOfSlots.get(k));
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                sb.append("\n");
                ++i2;
            }
        }
        return sb.toString();
    }

    public static void toPTBTree(File inputFile, File outputFile, String encoding) {
        ArrayList<CCGNode> ccgtrees = CCGNode.readCCGFile(inputFile, encoding);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(outputFile, encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        for (CCGNode ccgtree : ccgtrees) {
            pw.println("(" + ccgtree.toTreeString() + ")");
        }
        pw.close();
    }

    public static void hasNonMinimalHeads(File inputFile, String encoding) {
        ArrayList<CCGNode> treebank = CCGNode.readCCGFile(inputFile, encoding);
        int i = 0;
        for (CCGNode t : treebank) {
            t.hasNonMinimalHeads(false, ++i);
        }
    }

    public void hasNonMinimalHeads(boolean countPunctuation, int sentenceNumber) {
        ArrayList<CCGInternalNode> allNodes = this.collectNonTerminalNodes();
        List<CCGTerminalNode> allTerminals = this.collectTerminalNodes();
        IdentityHashMap<CCGTerminalNode, Integer> hights = new IdentityHashMap<CCGTerminalNode, Integer>();
        for (CCGTerminalNode t : allTerminals) {
            hights.put(t, t.height());
        }
        for (CCGInternalNode n : allNodes) {
            CCGTerminalNode terminalHead = n.getAnchorThroughPercolation();
            int terminalHeadHight = (Integer)hights.get(terminalHead);
            List<CCGTerminalNode> terminals = n.collectTerminalNodes();
            CCGTerminalNode minimalHead = terminalHead;
            int minimalHight = terminalHeadHight;
            for (CCGTerminalNode t : terminals) {
                int tHight;
                if (t == terminalHead || !countPunctuation && t.isPunctuation() || (tHight = ((Integer)hights.get(t)).intValue()) >= minimalHight) continue;
                minimalHight = tHight;
                minimalHead = t;
            }
            if (minimalHead == terminalHead) continue;
            System.out.println(String.valueOf(sentenceNumber) + ":\t" + this.toString() + "\n" + "\tParent: " + n.cat.toString() + "  Current Head: " + terminalHead.word + "  Min Head: " + minimalHead.word);
        }
    }

    public String toString() {
        return "<" + this.cat + ">";
    }

    public abstract String toStringWithAdditionalField();

    public void collectHead() {
    }

    public void fillSlots() {
        CCGParseResult pr;
        if (this.slots == null && (pr = CCGChart.goldParse(this)) != null) {
            this.slots = pr.dependency;
        }
    }

    public Set<Integer> collectNewInactiveNodes() {
        if (this.isTerminal()) {
            return Collections.emptySet();
        }
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (Pair<Integer, Integer> p : this.newlyFilledSlots.keySet()) {
            int index = p.getFirst();
            if (nodes.contains(index)) continue;
            boolean b = true;
            int j = 0;
            while (j < this.slots[index - this.start].length) {
                if (this.slots[index - this.start][j] == null) {
                    b = false;
                    break;
                }
                ++j;
            }
            if (!b) continue;
            nodes.add(index);
        }
        return nodes;
    }

    public CCGTerminalNode getTerminalNode(int index) {
        if (index < this.start || index > this.end) {
            throw new IllegalArgumentException("Try to get nodes out of the tree");
        }
        if (this instanceof CCGTerminalNode) {
            return (CCGTerminalNode)this;
        }
        CCGInternalNode node = (CCGInternalNode)this;
        if (index > node.children[0].end()) {
            return node.children[1].getTerminalNode(index);
        }
        return node.children[0].getTerminalNode(index);
    }

    public CCGTerminalNode getRightmostTerm() {
        return this.getTerminalNode(this.end);
    }

    public CCGTerminalNode getLeftmostTerm() {
        return this.getTerminalNode(this.start);
    }

    public String dependencyToHtml() {
        if (this.slots == null) {
            this.fillSlots();
        }
        if (this.slots == null) {
            return "Fail to discover dependency";
        }
        List<CCGTerminalNode> terms = this.collectTerminalNodes();
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellpadding=\"10\">\n");
        int i = 0;
        while (i < this.slots.length) {
            Object[] colors = new Object[]{"<font color=\"firebrick\">", "</font>", "<font color=\"mediumblue\">", "</font>", "<font color=\"green\">", "</font>", "<font color=\"orchid\">", "</font>", "<font color=\"mediumblue\">", "</font>", "<font color=\"green\">", "</font>", "<font color=\"orchid\">", "</font>"};
            sb.append("<tr>\n");
            sb.append("<td>");
            sb.append(i + 1);
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(String.format("<b>%s</b>\n", terms.get(i).word()));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(String.format("<i>%s</i>\n", String.format(terms.get(i).category().toColoredString(), colors)));
            sb.append("</td>\n");
            int j = 0;
            while (j < this.slots[i].length) {
                sb.append("<td>");
                if (this.slots[i][j] == null) {
                    sb.append(String.format("<font color=\"FF0000\"><b>%s</b></font>", "null"));
                } else {
                    int z2;
                    sb.append(colors[j % 4 * 2]);
                    ArrayList<String> heads = new ArrayList<String>();
                    for (int z2 : this.slots[i][j]) {
                        heads.add(terms.get(z2).word());
                    }
                    sb.append((String)heads.get(0));
                    z2 = 1;
                    while (z2 < heads.size()) {
                        sb.append(", " + (String)heads.get(z2));
                        ++z2;
                    }
                    sb.append(colors[j % 4 * 2 + 1]);
                }
                sb.append("</td>\n");
                ++j;
            }
            sb.append("</tr>\n");
            ++i;
        }
        sb.append("</table>\n");
        return sb.toString();
    }

    public static String toHTML(CCGNode result) {
        if (result.start != 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (result.source != null) {
            String[] ss = result.source.split("\\s");
            sb.append("<br><h3>" + ss[0].substring(3) + "</h3>\n");
        }
        sb.append("<pre>" + result.toIndentedTreeString() + "</pre>\n");
        sb.append(result.dependencyToHtml());
        return sb.toString();
    }

    public static void main(String[] args) {
        CCGNode c = CCGNode.getCCGNodeFromString("(<T S[dcl] 0 2> (<T S[dcl] 1 2> (<L S/S NN NN \u4e0b\u9762 S/S>) (<T S[dcl] 0 1> (<T S[dcl]\\NP 0 2> (<L (S[dcl]\\NP)/(S[dcl]\\NP) VV VV \u8bf7 (S[dcl]\\NP)/(S[dcl]\\NP)>) (<T S[dcl]\\NP 0 2> (<L (S[dcl]\\NP)/NP VV VV \u542c (S[dcl]\\NP)/NP>) (<T NP 1 2> (<T NP/NP 1 2> (<T S[dcl]/NP 1 2> (<T S/(S\\NP) 0 1> (<T NP 1 2> (<T NP 1 2> (<T NP/NP 1 2> (<T (NP/NP)/(NP/NP) 1 2> (<L NP NR NR \u7f8e\u56fd NP>) (<L ((NP/NP)/(NP/NP))\\NP DEG DEG \u4e4b ((NP/NP)/(NP/NP))\\NP>) ) (<L NP/NP NN NN \u97f3 NP/NP>) ) (<L NP NN NN \u8bb0\u8005 NP>) ) (<T NP 1 2> (<L NP/NP NR NR \u7c73\u514b NP/NP>) (<L NP NR NR \u963f\u5c14\u5df4\u65af\u7279 NP>) ) ) ) (<T (S[dcl]\\NP)/NP 1 2> (<T (S\\NP)/(S\\NP) 0 2> (<L ((S\\NP)/(S\\NP))/NP P P \u4ece ((S\\NP)/(S\\NP))/NP>) (<L NP NR NR \u5965\u65af\u8def NP>) ) (<L (S[dcl]\\NP)/NP VV VV \u53d1\u6765 (S[dcl]\\NP)/NP>) ) ) (<L (NP/NP)\\(S[dcl]/NP) DEC DEC \u7684 (NP/NP)\\(S[dcl]/NP)>) ) (<L NP NN NN \u62a5\u9053 NP>) ) ) ) ) ) (<L . PU PU \u3002 .>))", "test");
        System.out.println(c.toIndentedTreeString());
        System.out.println(c.getTerminalNode(2).categoryWithNoFeature());
        System.out.println(c.getTerminalNode((int)5).cat.removeModifier());
        CategoryObject cat = CategoryObject.fromPlainCat("((S/NP)\\(S/NP))/((S/NP)\\(S/NP))");
        System.out.println(cat.removeModifier());
        System.out.println("Done!");
        System.out.println(c.getTerminalNode(5));
    }
}

