/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.Cursor;
import java.awt.Graphics2D;

public final class POffscreenCanvas
implements PComponent {
    private final PBounds bounds;
    private PCamera camera;
    private int renderQuality = 1;
    static final int DEFAULT_RENDER_QUALITY = 1;

    public POffscreenCanvas(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("width must be at least zero, was " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("height must be at least zero, was " + n2);
        }
        this.bounds = new PBounds(0.0, 0.0, n, n2);
        this.setCamera(PUtil.createBasicScenegraph());
    }

    public void render(Graphics2D graphics2D) {
        if (graphics2D == null) {
            throw new IllegalArgumentException("graphics must not be null");
        }
        PPaintContext pPaintContext = new PPaintContext(graphics2D);
        pPaintContext.setRenderQuality(this.renderQuality);
        this.camera.fullPaint(pPaintContext);
    }

    public void setCamera(PCamera pCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = pCamera;
        if (pCamera != null) {
            pCamera.setComponent(this);
            pCamera.setBounds((PBounds)this.bounds.clone());
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setRenderQuality(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("renderQuality must be one of PPaintContext.HIGH_QUALITY_RENDERING or PPaintContext.LOW_QUALITY_RENDERING, was " + n);
        }
        this.renderQuality = n;
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void paintImmediately() {
    }

    public void popCursor() {
    }

    public void pushCursor(Cursor cursor) {
    }

    public void repaint(PBounds pBounds) {
    }

    public void setInteracting(boolean bl) {
    }
}

