###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


gold = $*[0]
hyp = $*[1]

#puts "Files input are #{file1} and #{file2}"
gf = File.open(gold)
hf = File.open(hyp)
line_num = 0

## Precision: percent of ones in hyp correctly classified as ones 
# (prec_points / 1_predict)
## Recall: Percent of actual ones found
# (prec_points / 1_actual)

prec_points = 0
predict_ones = 0
actual_ones = 0
correct = 0
total = 0

while(line1=gf.gets)
  sprec_points = 0
  spredict_ones = 0
  sactual_ones = 0
  scorrect = 0
  stotal = 0
  line_num += 1
  line2 = hf.gets
  if not line2
    $stderr.puts "WARNING: Hypoths file was smaller than gold file"
    break
  end
  goldList = line1.split(' ')
  hypList = line2.split(' ')
  if goldList.size != hypList.size
    $stderr.puts "Length mismatch: #{goldList.size}|#{hypList.size} on line #{line_num}"
  end
  
  goldList.each_index{ |i|
    if goldList[i] == "1" and hypList[i] == "1"
      sprec_points += 1
      spredict_ones += 1
      sactual_ones += 1
      scorrect += 1
#      print "1 "
    elsif goldList[i] == "1"
      sactual_ones += 1
#      print "n "
    elsif hypList[i] == "1"
      spredict_ones += 1
#      print "p "
    else
      scorrect += 1
#      print "0 "
    end
    stotal += 1
  }
#  print "\n"
  
  srecall = sprec_points.to_f / spredict_ones.to_f
  sprec = sprec_points.to_f / sactual_ones.to_f
  if spredict_ones == 0 or sactual_ones == 0 or (sprec + srecall) == 0.0
    sf = 0.0
  else
    sf = 2.0 * srecall * sprec / (sprec + srecall)
  end
  
#  puts "#{line_num} #{sf}"
  
  prec_points += sprec_points
  predict_ones += spredict_ones
  actual_ones += sactual_ones
  correct += scorrect
  total += stotal
  
#  puts "Line: #{line_num}"
#  puts "prec_points = #{prec_points}"
#  puts "predict_ones = #{predict_ones}"
#  puts "actual_ones = #{actual_ones}"
#  puts "correct = #{correct}"
  
end

precision = prec_points.to_f / predict_ones.to_f
recall = prec_points.to_f / actual_ones.to_f
fscore = 2.0 * recall * precision / (precision + recall)
accuracy = correct.to_f / total.to_f

puts "Results:\n"
puts "  Edited Recall:    #{recall}"
puts "  Edited Precision: #{precision}"
puts "  Edited F-score:   #{fscore}"
puts "  Accuracy:         #{accuracy}"

