///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"
#include "nl-fixedmatrix.h"

char psX[]   = "";
char psSpc[] = " ";

char psLBrace[]="{";
char psRBrace[]="}";
char psColon[]=":";


// for dynamic vector sizing
DiscreteDomain<int> domVSIZE;
class VSIZE : public DiscreteDomainRV<int,domVSIZE> {
 public: 
  VSIZE (  ) : DiscreteDomainRV<int,domVSIZE> ( ) { }
  VSIZE ( const char* ps ) : DiscreteDomainRV<int,domVSIZE> ( ps ) { }
  int getInt ( ) { return atoi(getString().c_str()); }
};
VSIZE M_SIZE("13");


//// SEMANTICS
//// I: individual entity in vector/matrix...
DiscreteDomain<int> domI;
class I : public DiscreteDomainRV<int,domI> {
 public:
  I ( )                : DiscreteDomainRV<int,domI> ( )    { }
  I ( const char* ps ) : DiscreteDomainRV<int,domI> ( ps ) { }
};
const I I_UNK("unk");
//const I I_NIL("-");

//// E: any referent, not just indices to vector/matrix
//DiscreteDomain<int> domE;
//typedef DiscreteDomainRV<int,domE> E;
typedef I E;

//// {Indexed,TimeStamped}Vector
class IndexedVector : public Matrix<Prob> {
 private:
  bool transpose;
 public:
  static const int NUM_VARS = 0;
  IndexedVector ( )                       : Matrix<Prob>( )   { transpose=false; }
  IndexedVector ( bool o )                : Matrix<Prob>( )   { transpose=true;  } // orientation on init
  IndexedVector ( int x, int y )          : Matrix<Prob>(x,y) { /*assert(x==M_SIZE.getInt()||x==1); assert(y==M_SIZE.getInt()||y==1);*/ transpose=false; }
  IndexedVector ( I ix, Prob p )          : Matrix<Prob>(M_SIZE.getInt(),1) { //cerr<<"Trying to set ix="<<ix<<" int(ix)="<<ix.getIndex()<<" p="<<p<<endl;
    this->set(ix.getIndex(),0)=p; } //cerr<<" result: "<<(*this)<<endl; } //creates vertical vector by default
  IndexedVector ( int x, int y, Prob p )  : Matrix<Prob>(x,y,p) { assert(x==M_SIZE.getInt()||x==1); assert(y==M_SIZE.getInt()||y==1); transpose=false; }
  IndexedVector ( const Matrix<Prob>& m ) : Matrix<Prob>(m)   { assert(m.xSize()==M_SIZE.getInt()||m.xSize()==1); assert(m.ySize()==M_SIZE.getInt()||m.ySize()==1); transpose=false; }
  IndexedVector ( const IndexedVector& m ) : Matrix<Prob>(m.xSize(),m.ySize()) {  transpose=false; //assert(m.xSize()==M_SIZE.getInt()||m.xSize()==1); assert(m.ySize()==M_SIZE.getInt()||m.ySize()==1);
    for(int i=0;i<xSize();i++) for(int j=0;j<ySize();j++) set(i,j)=m.get(i,j);
  }
  //IndexedVector ( const matrix<Prob>& m ) : Matrix<Prob>(m) { }

  void setTranspose( bool b ) { transpose=b; } // sets for reading in as transpose. does not calculate a transpose vector

  friend pair<StringInput,IndexedVector*> operator>> ( StringInput si, IndexedVector& m ) {
    return pair<StringInput,IndexedVector*>(si,&m);
  }
  friend StringInput operator>> ( pair<StringInput,IndexedVector*> si_m, const char* psD ) {
    if (StringInput(NULL)==si_m.first) return si_m.first;
    StringInput si; I i,j; Prob p;
    if (si_m.second->transpose) {
      if ((*si_m.second)==IndexedVector()) { 
	si_m.second->init(1,M_SIZE.getInt(),Prob()); 
      }
      si=si_m.first>>i>>" : ">>j>>" = ">>p>>psD;
      if ( si!=NULL ) si_m.second->set(0,j.getIndex())=p;
    } else {
      if ((*si_m.second)==IndexedVector()) { si_m.second->init(M_SIZE.getInt(),1,Prob()); } //cerr<<" vector index: -"; }
      si=si_m.first>>i>>" : ">>j>>" = ">>p>>psD;
      //cerr<<(i.getIndex()==0?"":",")<<i<<(i.getIndex()>=(M_SIZE.getInt()-1) ? "\n":"");
      if ( si!=NULL ) si_m.second->set(i.getIndex(),0)=p;
    }
    return si;
  }
  // On output, this looks like join(',')
  friend ostream& operator<< ( ostream& os, const IndexedVector& a ) { 
    for (int i=0;i<a.xSize();i++) {
      for (int j=0;j<a.ySize();j++) {
	os<<((j==0)?"":",")<<a.get(Id<int>(i),Id<int>(j));
      } 
      os<<((i==a.xSize()-1)?"":",");
    }
    return os;  
  }
};

//// {Indexed,TimeStamped}Matrix
class IndexedMatrix : public Matrix<Prob> {
 public:
  static  const int NUM_VARS = 0;
  IndexedMatrix ( )                       : Matrix<Prob>( ) { }
  IndexedMatrix ( int x, int y )          : Matrix<Prob>(x,y) { /*assert(x==M_SIZE.getInt()||x==1); assert(y==M_SIZE.getInt()||y==1);*/ }
  IndexedMatrix ( int x, int y, Prob p )  : Matrix<Prob>(x,y,p) { assert(x==M_SIZE.getInt()||x==1); assert(y==M_SIZE.getInt()||y==1); }
  IndexedMatrix ( I ix, I iy, Prob p )    : Matrix<Prob>(M_SIZE.getInt(),M_SIZE.getInt()) { Prob pm=set(ix.getIndex(),iy.getIndex()); pm=p; }
  IndexedMatrix ( const Matrix<Prob>& m ) : Matrix<Prob>(m) { assert(m.xSize()==M_SIZE.getInt()||m.xSize()==1); assert(m.ySize()==M_SIZE.getInt()||m.ySize()==1); }
  IndexedMatrix ( const IndexedMatrix& m ) : Matrix<Prob>(m.xSize(),m.ySize()) { //assert(m.xSize()==M_SIZE.getInt()||m.xSize()==1); assert(m.ySize()==M_SIZE.getInt()||m.ySize()==1); 
    for(int i=0;i<m.xSize();i++) for(int j=0;j<m.ySize();j++) set(i,j)=m.get(i,j);
  }
  //IndexedMatrix ( const matrix<Prob>& m ) : Matrix<Prob>(m) { }
  friend pair<StringInput,IndexedMatrix*> operator>> ( StringInput si, IndexedMatrix& m ) {
    return pair<StringInput,IndexedMatrix*>(si,&m);
  }
  friend StringInput operator>> ( pair<StringInput,IndexedMatrix*> si_m, const char* psD ) {
    if (StringInput(NULL)==si_m.first) return si_m.first;
    StringInput si; I i,j; Prob p;
    if ((*si_m.second)==IndexedMatrix()) { si_m.second->init(M_SIZE.getInt(),M_SIZE.getInt(),Prob()); }
    si=si_m.first>>i>>" : ">>j>>" = ">>p>>psD;
    if ( si!=NULL ) si_m.second->set(i.getIndex(),j.getIndex())=p;
    return si;
  }
};

//// Evec: referent vector.  individuals are I (and typedef-ed as E)
typedef IndexedVector Evec;
//std::map<IndexedVector,IndexedVector> domEvec;
//typedef RefRV<IndexedVector,domEvec> Evec;
const Evec E_BOT("-");
const Evec E_TOP("-");
//const Evec E_UNK("unk");

//// L: relation symbol.  actual matrix is an LModel
DiscreteDomain<int> domL;
typedef DiscreteDomainRV<int,domL> L;
const L L_BOT("-");
const L L_TOP("h");



//// EVERYTHING ELSE
//// U: left or right indicator for grammar rule
DiscreteDomain<int> domU;
typedef DiscreteDomainRV<int,domU> U;
const U U_L("l");
const U U_R("r");
//const U U_BOT("-");
const U U_TOP("l");

//// D: center-embedding depth
DiscreteDomain<int> domD;
typedef DiscreteDomainRV<int,domD> D;
//const D D_BOT("-");
const D D_TOP("0");

typedef DelimitedJoint2DRV<psX,U,psSpc,D,psX> UD;
//const UD UD_BOT(U_BOT,D_BOT);
const UD UD_TOP(U_TOP,D_TOP);

//// B: boolean
DiscreteDomain<int> domB;
typedef DiscreteDomainRV<int,domB> B;
const B B_1("1");
const B B_0("0");

//// C: syntactic symbol
//DiscreteDomain<int> domC;
//typedef DiscreteDomainRV<int,domC> C;
DiscreteDomain<int> domC;
class C : public DiscreteDomainRV<int,domC> {
 private:
  static SimpleHash<C,B> hToTerm;
  void calcDetModels ( string s ) {
    if (!hToTerm.contains(*this)) {
      hToTerm.set(*this) = (('A'<=s[0] && s[0]<='Z') || s.find('_')!=string::npos) ? B_0 : B_1;
    }
  }
 public:
  C ( )                                      : DiscreteDomainRV<int,domC> ( )    { }
  C ( const DiscreteDomainRV<int,domC>& rv ) : DiscreteDomainRV<int,domC>(rv) { }
  C ( const char* ps )                       : DiscreteDomainRV<int,domC> ( ps ) { calcDetModels(ps); }
  //C ( string s ) : DiscreteDomainRV<int,domC> ( s )  { calcDetModels(s); }
  B getTerm ( ) const { return hToTerm.get(*this); }
  friend pair<StringInput,C*> operator>> ( StringInput si, C& x ) { return pair<StringInput,C*>(si,&x); }
  friend StringInput operator>> ( pair<StringInput,C*> si_x, const char* psD ) {
    if ( si_x.first == NULL ) return NULL;
    StringInput si=si_x.first>>(DiscreteDomainRV<int,domC>&)*si_x.second>>psD;
    si_x.second->calcDetModels(si_x.second->getString()); return si; }
};
SimpleHash<C,B> C::hToTerm;
const C C_BOT("-");
const C C_TOP("REST");


//// CC: helper model -- child constituents
typedef DelimitedJoint2DRV<psX,C,psSpc,C,psX> CC;
//const CC CC_TOP (C_TOP,C_TOP);

//// LC: rel-annotated syntax
typedef DelimitedJoint2DRV<psX,L,psColon,C,psX> LC;
const LC LC_BOT(L_BOT,C_BOT);
const LC LC_TOP(L_TOP,C_TOP);
//typedef LC G;

//// G: constituent category (=LC)...
DiscreteDomain<int> domG;
//typedef DiscreteDomainRV<int,domG> G;
class G : public DiscreteDomainRV<int,domG> {
 private:
  static SimpleHash<G,L> hToL;
  static SimpleHash<G,C> hToC;
  static SimpleHash<G,B> hToTerm;
  void calcDetModels ( string s ) {
    if (!hToL.contains(*this)) {
      size_t i=s.find(':');
      assert(i!=string::npos);
      hToL.set(*this) = L(s.substr(0,i).c_str());
    }
    if (!hToC.contains(*this)) {
      size_t i=s.find(':');
      assert(i!=string::npos); 
      hToC.set(*this) = C(s.substr(i+1).c_str());
      hToTerm.set(*this) = (('A'<=s.substr(i+1).c_str()[0] && s.substr(i+1).c_str()[0]<='Z') || s.find('_')!=string::npos) ? B_0 : B_1;
    }
  }
 public:
  G ( )                : DiscreteDomainRV<int,domG> ( )    { }
  G ( const DiscreteDomainRV<int,domG>& rv ) : DiscreteDomainRV<int,domG>(rv) { }
  G ( const char* ps ) : DiscreteDomainRV<int,domG> ( ps ) { calcDetModels(ps); }
  //G ( string s ) : DiscreteDomainRV<int,domG> ( s )  { calcDetModels(s); }
  L getL    ( )     const { return hToL.get(*this); }
  C getC    ( )     const { return hToC.get(*this); }
  B getTerm ( ) const { return hToTerm.get(*this); }
  friend pair<StringInput,G*> operator>> ( StringInput si, G& m ) { return pair<StringInput,G*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,G*> si_m, const char* psD ) {
    if ( si_m.first == NULL ) return NULL;
    StringInput si=si_m.first>>(DiscreteDomainRV<int,domG>&)*si_m.second>>psD;
    si_m.second->calcDetModels(si_m.second->getString()); return si; }
};
SimpleHash<G,L> G::hToL;
SimpleHash<G,C> G::hToC;
SimpleHash<G,B> G::hToTerm;

//// LCLC: child rel-annotated syntax
typedef DelimitedJoint2DRV<psX,LC,psSpc,LC,psX> LCLC;
const LCLC LCLC_BOT (LC_BOT,LC_BOT);

//// UDL: relations with U and D to be consistent with HHMM
typedef DelimitedJoint2DRV<psX,UD,psSpc,L,psX> UDL;
const UDL UDL_TOP (UD_TOP,L_TOP);

//// UDLC: parent category in M
typedef DelimitedJoint2DRV<psX,UD,psSpc,LC,psX> UDLC;
const UDLC UDLC_TOP(UD_TOP,LC_TOP);
//typedef UDLC G;

//// UDLCLCLC: parent-to-children binary rules
typedef DelimitedJoint2DRV<psX,UDLC,psSpc,LCLC,psX> UDLCLCLC;

//// GE: true grammar rule symbol (w/ vector)
//typedef DelimitedJoint3DRV<psX,L,psColon,C,psLBrace,E,psRBrace> LCE;
//typedef DelimitedJoint2DRV<psX,UD,psSpc,LCE,psX> GE;
//const GE GE_TOP (UD_TOP,LCE(L_TOP,C_TOP,E_TOP));
typedef DelimitedJoint2DRV<psX,UDLC,psSpc,Evec,psX> GE;
const GE GE_TOP (UDLC_TOP,E_TOP);

/*** REPLACED BY I
//// HW: real headwords vs. unk
DiscreteDomain<int> domHW;
typedef DiscreteDomainRV<int,domHW> HW;
const HW HW_UNK ("unk");
//// HW headword model
typedef CPT1DModel<HW,LogProb> HWModel;
***/

//// MODELS

//// L Semantics Model, E given L E... STORED AS PROB, not LogProb
//typedef CPT3DModel<E,L,E,Prob> LModel;
//typedef IndexedMatrix LModel;
class LModel {
 public:
  typedef SimpleHash< UDL, IndexedMatrix>::const_iterator const_iterator;
  static SimpleHash< UDL, IndexedMatrix> hL;
  //typedef SimpleHash< Joint2DRV<LC,LCLC>, IndexedMatrix>::IterVal IterVal;

  // Hash Operators
  const_iterator begin () { return LModel::hL.begin(); };
  const_iterator end   () { return LModel::hL.end();   };

  // Input/Output Methods
  friend pair<StringInput,LModel*> operator>> ( StringInput si, LModel& m ) {
    return pair<StringInput,LModel*>(si,&m);
  }
  friend StringInput operator>> ( pair<StringInput,LModel*> si_m, const char* psD ) {
    if (StringInput(NULL)==si_m.first) return si_m.first;
    StringInput si; UDL udl;
    //if ( (si=si_m.first>>"L ">>l>>" ")!=NULL && (si=si>>si_m.second->hL.set(l)>>psD)!=NULL ||
    if ( (si=si_m.first>>udl>>" ")!=NULL ) {
      if (!si_m.second->hL.contains(udl)) { /*cerr<<"    INITIALIZING M...";*/ si_m.second->hL.set(udl).init(M_SIZE.getInt(),M_SIZE.getInt(),Prob()); }//cerr<<" vector index: "; }
	//cerr<<(i.getIndex()==0?"":",")<<i<<(i.getIndex()>=(M_SIZE.getInt()-1) ? "\n":"");
      si=si>>si_m.second->hL.set(udl)>>psD;
      //si_m.second->hL.set(l).set(g.second.third.getIndex(),g.second.first.getIndex()) = p;
    }
    return si;
  }

};
SimpleHash< UDL, IndexedMatrix> LModel::hL;


//// M Syntax Model, LC LC given GE=CE... STORED AS PROB, not LogProb
//typedef CPT2DModel<LCLC,GE,Prob> MModel;
class MModel {
 public:
  typedef SimpleHash< UDLCLCLC, IndexedVector>::const_iterator const_iterator;
  static SimpleHash< UDLCLCLC, IndexedVector> hM;
  //typedef SimpleHash< Joint2DRV<LC,LCLC>, IndexedVector>::IterVal IterVal;

  // Hash Operators
  const_iterator begin () { return MModel::hM.begin(); };
  const_iterator end   () { return MModel::hM.end();   };

  // Input/Output Methods
  friend pair<StringInput,MModel*> operator>> ( StringInput si, MModel& m ) {
    return pair<StringInput,MModel*>(si,&m);
  }
  friend StringInput operator>> ( pair<StringInput,MModel*> si_m, const char* psD ) {
    if (StringInput(NULL)==si_m.first) return si_m.first;
    StringInput si; UDLC udlc; LCLC lclc;
    //if ( (si=si_m.first>>"L ">>l>>" ")!=NULL && (si=si>>si_m.second->hL.set(l)>>psD)!=NULL ||
    if ( (si=si_m.first>>udlc>>" ">>lclc>>" ")!=NULL ) {
      UDLCLCLC pudlclclc(udlc,lclc);
      if (!si_m.second->hM.contains(pudlclclc)) { /*cerr<<"    INITIALIZING M...";*/ si_m.second->hM.set(pudlclclc).init(M_SIZE.getInt(),1,Prob()); }//cerr<<" vector index: "; }
	//cerr<<(i.getIndex()==0?"":",")<<i<<(i.getIndex()>=(M_SIZE.getInt()-1) ? "\n":"");
      si=si>>si_m.second->hM.set(pudlclclc)>>psD;
      //si_m.second->hM.set(pudlclclc).set(g.second.third.getIndex(),g.second.first.getIndex()) = p;
    }
    return si;
  }

};
SimpleHash< UDLCLCLC, IndexedVector> MModel::hM;


//// GErModel: root symbol (prior) Model
class GErModel {
 public:
  typedef SimpleHash< UDLC, IndexedVector>::const_iterator const_iterator;
  static SimpleHash< UDLC, IndexedVector> hGEr;
  //typedef SimpleHash< Joint2DRV<LC,LCLC>, IndexedMatrix>::IterVal IterVal;

  // Hash Operators
  const_iterator begin () { return GErModel::hGEr.begin(); };
  const_iterator end   () { return GErModel::hGEr.end();   };

  // Input/Output Methods
  friend pair<StringInput,GErModel*> operator>> ( StringInput si, GErModel& m ) {
    return pair<StringInput,GErModel*>(si,&m);
  }
  friend StringInput operator>> ( pair<StringInput,GErModel*> si_m, const char* psD ) {
    if (StringInput(NULL)==si_m.first) return si_m.first;
    StringInput si; UDLC udlc;
    //if ( (si=si_m.first>>"L ">>l>>" ")!=NULL && (si=si>>si_m.second->hL.set(l)>>psD)!=NULL ||
    if ( (si=si_m.first>>udlc>>" ")!=NULL ) {
      UDLC pudlc(udlc);
      if (!si_m.second->hGEr.contains(pudlc)) { /*cerr<<"    INITIALIZING GEr...";*/ si_m.second->hGEr.set(pudlc).init(1,M_SIZE.getInt(),Prob()); si_m.second->hGEr.set(pudlc).setTranspose(true); }//cerr<<" vector index: "; }
	//cerr<<(i.getIndex()==0?"":",")<<i<<(i.getIndex()>=(M_SIZE.getInt()-1) ? "\n":"");
      si=si>>si_m.second->hGEr.set(pudlc)>>psD;
      //si_m.second->hGEr.set(pudlc).set(g.second.third.getIndex(),g.second.first.getIndex()) = p;
    }
    return si;
  }

};
SimpleHash< UDLC, IndexedVector> GErModel::hGEr;




//// Model of LC (prior)
typedef CPT1DModel<LC,LogProb> LCModel;
////// Model of GE (prior)
//typedef CPT1DModel<GE,LogProb> GEModel;
//typedef GErModel GEModel;

class GEModel {
 public:
  typedef SimpleHash< UDLC, IndexedVector>::const_iterator const_iterator;
  static SimpleHash< UDLC, IndexedVector> hGEr;
  //typedef SimpleHash< Joint2DRV<LC,LCLC>, IndexedMatrix>::IterVal IterVal;

  // Hash Operators
  const_iterator begin () { return GEModel::hGEr.begin(); };
  const_iterator end   () { return GEModel::hGEr.end();   };

  // Input/Output Methods
  friend pair<StringInput,GEModel*> operator>> ( StringInput si, GEModel& m ) {
    return pair<StringInput,GEModel*>(si,&m);
  }
  friend StringInput operator>> ( pair<StringInput,GEModel*> si_m, const char* psD ) {
    if (StringInput(NULL)==si_m.first) return si_m.first;
    StringInput si; UDLC udlc;
    //if ( (si=si_m.first>>"L ">>l>>" ")!=NULL && (si=si>>si_m.second->hL.set(l)>>psD)!=NULL ||
    if ( (si=si_m.first>>udlc>>" ")!=NULL ) {
      UDLC pudlc(udlc);
      if (!si_m.second->hGEr.contains(pudlc)) { si_m.second->hGEr.set(pudlc).init(1,M_SIZE.getInt(),Prob()); si_m.second->hGEr.set(pudlc).setTranspose(true); }//cerr<<" vector index: "; }
	//cerr<<(i.getIndex()==0?"":",")<<i<<(i.getIndex()>=(M_SIZE.getInt()-1) ? "\n":"");
      si=si>>si_m.second->hGEr.set(pudlc)>>psD;
      //si_m.second->hGEr.set(pudlc).set(g.second.third.getIndex(),g.second.first.getIndex()) = p;
    }
    return si;
  }

};
SimpleHash< UDLC, IndexedVector> GEModel::hGEr;


//// Model of GEr (prior incl. L)
//typedef CPT1DModel<GEr,LogProb> GErModel;
//// Model of GE given GE (unary branching expansion)
typedef CPT2DModel<GE,GE,LogProb> GEuModel;



//// Model of GEGE given GE (binary branching expansion)... STORED AS PROB, not LogProb
//typedef CPT2DModel<GEGE,GE,Prob> GEGEModel;

/*
//// H: pre-clustered word (array of letters, arranged last to first)...
//typedef StaticSafeArray<5,Lt> H;
DiscreteDomain<int> domainH;
class H : public DiscreteDomainRV<int,domainH>, public StaticSafeArray<5,Lt> {
 public:
  H ( ) { }
  H ( const char* ps ) : DiscreteDomainRV<int,domainH>(ps) {
    char psTemp[2]="-"; int n=strlen(ps);
    for(int i=0;i<5;i++) {
      psTemp[0]=(i<n)?ps[n-i-1]:'_';
      //cout<<"!!!!!!!!!!!!!!!!!!"<<psTemp<<endl;
      StaticSafeArray<5,Lt>::set(i)=Lt(psTemp);
    }
  }
  friend pair<StringInput,H*> operator>> ( const StringInput ps, H& rv ) { return pair<StringInput,H*>(ps,&rv); }
  friend StringInput operator>> ( pair<StringInput,H*> si_h, const char* psDlm ) {
    if(si_h.first==NULL)return si_h.first; String s; StringInput si=si_h.first>>s>>psDlm; *si_h.second=s.c_array(); return si; }
  bool   operator== ( const H& w ) const { return DiscreteDomainRV<int,domainH>::operator==(w); }
  size_t getHashKey ( )            const { return DiscreteDomainRV<int,domainH>::getHashKey();  }
};
const H H_UNK("unk");
*/


//// GI: ad hoc preterminal element...
class GI : public DelimitedJoint2DRV<psX,G,psLBrace,I,psRBrace> {
  typedef DelimitedJoint2DRV<psX,G,psLBrace,I,psRBrace> Parent;
 public:
  GI ( )                                : Parent()    { }
  template<class P>
  GI ( const GI::ArrayIterator<P>& it )               { setVal(it); }
  GI ( const G& g, const I& i )         : Parent(g,i) { }
  const G& getG ( ) const { return first;  }
  const I& getI ( ) const { return second; }
  template<class P> class ArrayIterator : public Parent::ArrayIterator<P> {
   public:
    G::ArrayIterator<P>& setG ( )  { return Parent::ArrayIterator<P>::first;  }
    I::ArrayIterator<P>& setI ( )  { return Parent::ArrayIterator<P>::second; }
  };
  friend pair<StringInput,GI*> operator>> ( StringInput si, GI& gi ) { return pair<StringInput,GI*>(si,&gi); }
  friend StringInput operator>> ( pair<StringInput,GI*> si_gi, const char* psD ) {
    if ( si_gi.first == NULL ) return NULL;
    StringInput si = si_gi.first>>*(Parent*)si_gi.second>>psD;
    return si;
  }
};
//const GI GI_LEX(G_LEX,I_NIL);
//const GI GI_TOP(G_TOP,I_NIL);
//const GI GI_RST(G_RST,I_NIL);


//// H is the new headword model... calling IModel for historical reasons
typedef CPT1DModel<H,LogProb> IModel;
