/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.collectors;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.SimpleEquivalenceClass;
import babel.content.eqclasses.collectors.EquivalenceClassCollector;
import babel.content.eqclasses.filters.EquivalenceClassFilter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleEquivalenceClassCollector
extends EquivalenceClassCollector {
    protected static final String WORD_DELIM_REGEX = "[\\|\\$\\*\\s\"'\\-\\+=,;:\u00ac\u00b4\u00ac\u00aa{}()<>\\[\\]\\.\\?\u00ac\u00f8!\u00ac\u00b0\u201a\u00c4\u00ec\u201a\u00c4\u00fa\u201a\u00c4\u00f9\u201a\u00c4\u00f2\u201a\u00c4\u00f4\u00ac\u2020]+";

    public SimpleEquivalenceClassCollector(List<EquivalenceClassFilter> filters, boolean caseSensitive) {
        super(SimpleEquivalenceClass.class.getName(), filters, caseSensitive);
    }

    public SimpleEquivalenceClassCollector(boolean caseSensitive) {
        this((List<EquivalenceClassFilter>)null, caseSensitive);
    }

    @Override
    public Set<EquivalenceClass> collect(InputStreamReader corpusReader, int maxEquivalenceClass) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(corpusReader);
        HashMap<String, SimpleEquivalenceClass> eqs = new HashMap<String, SimpleEquivalenceClass>();
        int count = 0;
        while ((line = reader.readLine()) != null) {
            String[] toks;
            String[] stringArray = toks = line.split(WORD_DELIM_REGEX);
            int n = toks.length;
            int n2 = 0;
            while (n2 < n) {
                String tok = stringArray[n2];
                SimpleEquivalenceClass tmpEq = (SimpleEquivalenceClass)this.m_eqClass.newInstance();
                tmpEq.init(tok, this.m_eqCaseSensitive);
                if (!eqs.containsKey(tmpEq.getWord()) && (maxEquivalenceClass < 0 || count < maxEquivalenceClass) && SimpleEquivalenceClassCollector.keep(tmpEq, this.m_filters)) {
                    tmpEq.assignId();
                    eqs.put(tmpEq.getWord(), tmpEq);
                    ++count;
                }
                ++n2;
            }
        }
        reader.close();
        return new HashSet<EquivalenceClass>(eqs.values());
    }
}

