/*
 	APS - Affinity Propagation for Segmentation, a linear text segmenter.
 
    Copyright (C) 2011, Anna Kazantseva

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */


package commandln;

public class ParamBase implements IParam
{
	protected String mName;
	protected boolean mMandatory;
	protected boolean mValue;
	protected boolean mFound = false;

	public ParamBase(String name, boolean mandatory, boolean value)
	{
		mName = name;
		mMandatory = mandatory;
		mValue = value;
	}

	public boolean CompareName(String name) {return mName.equals(name);}
	public void MarkAsFound() {mFound = true;}
	public boolean ValueRequired() {return mValue;}
	public boolean IsMandatory() {return mMandatory;}
	public boolean IsFound() {return mFound;}

	public void ParseValue(String value) throws Exception {throw new Exception();}
	
	public String getString() throws Exception {throw new Exception();}
	public int getInt() throws Exception {throw new Exception();}
	public boolean getBool() throws Exception {throw new Exception();}
	public double getDouble() throws Exception {throw new Exception();}

	public String [] getStringArray() throws Exception {throw new Exception();}
	public int [] getIntArray() throws Exception {throw new Exception();}
	public double [] getDoubleArray() throws Exception {throw new Exception();}
}
