/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    static final long serialVersionUID = -2524057065260042957L;
    private E[] mBuckets;
    private int mSize = 0;
    static final float LOAD_FACTOR = 0.75f;
    static final float RESIZE_FACTOR = 1.5f;

    public CompactHashSet(int initialCapacity) {
        if (initialCapacity < 1) {
            String msg = "Capacity must be positive. Found initialCapacity=" + initialCapacity;
            throw new IllegalArgumentException(msg);
        }
        this.alloc(initialCapacity);
    }

    public CompactHashSet(E ... es) {
        this(1);
        for (E e : es) {
            this.add(e);
        }
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            String msg = "Cannot add null to CompactHashSet";
            throw new NullPointerException(msg);
        }
        int slot = this.findSlot(e);
        if (this.mBuckets[slot] != null) {
            return false;
        }
        if ((float)(this.mSize + 1) >= 0.75f * (float)this.mBuckets.length) {
            this.realloc();
            slot = this.findSlot(e);
            if (this.mBuckets[slot] != null) {
                throw new IllegalStateException("");
            }
        }
        this.mBuckets[slot] = e;
        ++this.mSize;
        return true;
    }

    @Override
    public void clear() {
        this.alloc(1);
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            String msg = "Compact hash sets do not support null objects.";
            throw new NullPointerException(msg);
        }
        E o2 = this.mBuckets[this.findSlot(o)];
        return o2 != null && o.equals(o2);
    }

    @Override
    public Iterator<E> iterator() {
        return new BucketIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        int slot = this.findSlot(o);
        if (this.mBuckets[slot] == null) {
            return false;
        }
        this.mBuckets[slot] = null;
        this.tampCollisions(slot);
        --this.mSize;
        return true;
    }

    void tampCollisions(int index) {
        int i = this.nextIndex(index);
        while (this.mBuckets[i] != null) {
            int slot = this.findSlot(this.mBuckets[i]);
            if (slot != i) {
                this.mBuckets[slot] = this.mBuckets[i];
                this.mBuckets[i] = null;
            }
            i = this.nextIndex(i);
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object o : collection) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        for (int i = 0; i < this.mBuckets.length; ++i) {
            if (this.mBuckets[i] == null || !collection.contains(this.mBuckets[i])) continue;
            modified = true;
            this.mBuckets[i] = null;
            this.tampCollisions(i);
            --this.mSize;
        }
        return modified;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.mSize];
        int nextIndex = 0;
        for (int i = 0; i < this.mBuckets.length; ++i) {
            if (this.mBuckets[i] == null) continue;
            result[nextIndex++] = this.mBuckets[i];
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        T[] result = array.length >= this.mSize ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), this.mSize);
        int nextIndex = 0;
        for (int i = 0; i < this.mBuckets.length; ++i) {
            if (this.mBuckets[i] == null) continue;
            E next = this.mBuckets[i];
            result[nextIndex++] = next;
        }
        if (result.length > this.mSize) {
            result[this.mSize] = null;
        }
        return result;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    int findSlot(Object e) {
        int i = this.firstIndex(e);
        while (this.mBuckets[i] != null) {
            if (this.mBuckets[i].equals(e)) {
                return i;
            }
            i = this.nextIndex(i);
        }
        return i;
    }

    int firstIndex(Object e) {
        return Math.abs(CompactHashSet.supplementalHash(e.hashCode())) % this.mBuckets.length;
    }

    int nextIndex(int index) {
        return (index + 1) % this.mBuckets.length;
    }

    void alloc(int capacity) {
        if (capacity < 0) {
            String msg = "Capacity must be non-negative. Found capacity=" + capacity;
            throw new IllegalArgumentException(msg);
        }
        Object[] buckets = new Object[capacity];
        this.mBuckets = buckets;
        this.mSize = 0;
    }

    void realloc() {
        E[] oldBuckets = this.mBuckets;
        long capacity = Math.max((long)(1.5f * (float)this.mBuckets.length), (long)(this.mBuckets.length + 1));
        if (capacity > Integer.MAX_VALUE) {
            String msg = "Not enough room to resize. Last capacity=" + this.mBuckets.length + " Failed New capacity=" + capacity;
            throw new IllegalArgumentException(msg);
        }
        this.alloc((int)capacity);
        for (int i = 0; i < oldBuckets.length; ++i) {
            if (oldBuckets[i] == null) continue;
            this.add(oldBuckets[i]);
        }
    }

    static int supplementalHash(int n) {
        int n2 = n ^ n >>> 20 ^ n >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 7799253382220016205L;
        final CompactHashSet<F> mSet;

        public Serializer() {
            this(null);
        }

        public Serializer(CompactHashSet<F> set) {
            this.mSet = set;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(((CompactHashSet)this.mSet).mBuckets.length);
            out.writeInt(this.mSet.size());
            for (int i = 0; i < ((CompactHashSet)this.mSet).mBuckets.length; ++i) {
                if (((CompactHashSet)this.mSet).mBuckets[i] == null) continue;
                out.writeObject(((CompactHashSet)this.mSet).mBuckets[i]);
            }
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            int capacity = in.readInt();
            int size = in.readInt();
            CompactHashSet<Object> result = new CompactHashSet<Object>(capacity);
            for (int i = 0; i < size; ++i) {
                Object f = in.readObject();
                result.add(f);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BucketIterator
    implements Iterator<E> {
        int mNextBucket = 0;
        int mRemoveIndex = -1;

        BucketIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.mNextBucket < CompactHashSet.this.mBuckets.length) {
                if (CompactHashSet.this.mBuckets[this.mNextBucket] != null) {
                    return true;
                }
                ++this.mNextBucket;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.mRemoveIndex = this.mNextBucket++;
            return CompactHashSet.this.mBuckets[this.mRemoveIndex];
        }

        @Override
        public void remove() {
            if (this.mRemoveIndex == -1) {
                throw new IllegalStateException();
            }
            ((CompactHashSet)CompactHashSet.this).mBuckets[this.mRemoveIndex] = null;
            --CompactHashSet.this.mSize;
            this.mRemoveIndex = -1;
        }
    }
}

