/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import util.FileUtil;

public class Bz2Util {
    private static String decompressFromFile(File outputFile) {
        StringBuilder result = new StringBuilder();
        try {
            FileInputStream inputStream = new FileInputStream(outputFile);
            inputStream.read();
            inputStream.read();
            BufferedReader gzipReader = new BufferedReader(new InputStreamReader(new CBZip2InputStream(inputStream)));
            int bufSize = 1000;
            char[] cbuf = new char[bufSize];
            int readChars = 0;
            while ((readChars = gzipReader.read(cbuf)) != -1) {
                if (readChars == 1000) {
                    result.append(cbuf);
                    continue;
                }
                char[] cbufTrunc = Arrays.copyOf(cbuf, readChars);
                result.append(cbufTrunc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private static void compressInFile(String randomString, File outputFile) {
        try {
            FileOutputStream fileStream = new FileOutputStream(outputFile);
            BufferedWriter gzipWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new CBZip2OutputStream(fileStream), "UTF-8"));
            gzipWriter.write(randomString);
            gzipWriter.close();
            fileStream.close();
        }
        catch (Exception e) {
            System.err.println("Problems while writing bzip2 file");
            e.printStackTrace();
            return;
        }
    }

    private static String getRandomString() {
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j < 10001) {
            int i = 33;
            while (i < 127) {
                sb.append((char)i);
                ++i;
            }
            ++j;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        File outputFileCompressed = new File("tmp/bz2_tryout.txt.bz2");
        String randomString = Bz2Util.getRandomString();
        String readString = Bz2Util.decompressFromFile(outputFileCompressed);
        System.out.println(readString.equals(randomString));
    }

    public static void main1(String[] args) {
        File outputFileCompressed = new File("tmp/bz2_tryout.bz2");
        File outputFile = new File("tmp/bz2_tryout.txt");
        String randomString = Bz2Util.getRandomString();
        FileUtil.append(randomString, outputFile);
        Bz2Util.compressInFile(randomString, outputFileCompressed);
        String readString = Bz2Util.decompressFromFile(outputFileCompressed);
        System.out.println(readString.equals(randomString));
        System.out.println(randomString);
        System.out.println(readString);
    }
}

