/*
 * Decompiled with CFR 0.152.
 */
package tsg.dop;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import settings.Parameters;
import tsg.CFSG;
import tsg.TSNode;
import util.FileUtil;
import util.PrintProgressStatic;
import util.Utility;

public class DOP_MaxDepth
extends CFSG<Integer> {
    Hashtable<String, Integer> Etrees = new Hashtable();

    public void freeMemory() {
        this.Etrees.clear();
    }

    private void readTreesFromCorpus() {
        int count = 1;
        PrintProgressStatic.start("Reading trees from sentence:");
        for (TSNode TreeLine : Parameters.trainingCorpus.treeBank) {
            List<String> subTrees = TreeLine.allSubTrees(Parameters.maxDepth);
            for (String etree : subTrees) {
                Utility.increaseStringInteger(this.Etrees, etree, 1);
            }
            PrintProgressStatic.next();
            ++count;
        }
        PrintProgressStatic.end();
        String log = "Read trees from corups. \n # Trees: " + this.Etrees.size();
        FileUtil.appendReturn(log, Parameters.logFile);
    }

    private Hashtable[] sortTreesAndFilter() {
        Hashtable[] ETreesDepth = new Hashtable[Parameters.maxDepth];
        int d = 0;
        while (d < Parameters.maxDepth) {
            ETreesDepth[d] = new Hashtable();
            ++d;
        }
        Enumeration<String> e = this.Etrees.keys();
        while (e.hasMoreElements()) {
            String eTree = e.nextElement();
            Integer count = this.Etrees.get(eTree);
            TSNode TN = new TSNode(eTree, false);
            int bucket = TN.maxDepth(false) - 1;
            ETreesDepth[bucket].put(eTree, count);
        }
        String log = "Sorted trees. \n";
        int d2 = 0;
        while (d2 < Parameters.maxDepth) {
            log = String.valueOf(log) + "\t#trees of depth " + (d2 + 1) + ": " + ETreesDepth[d2].size() + "\n";
            ++d2;
        }
        String[][] TreeArrayDepth = new String[Parameters.maxDepth - 1][];
        int d3 = 1;
        while (d3 < Parameters.maxDepth) {
            TreeArrayDepth[d3 - 1] = ETreesDepth[d3].keySet().toArray(new String[0]);
            int length = TreeArrayDepth[d3 - 1].length;
            while (ETreesDepth[d3].size() > Parameters.maxTreesInDepth) {
                int randomIndex = Utility.randomInteger(length);
                String treeToRemove = TreeArrayDepth[d3 - 1][randomIndex];
                ETreesDepth[d3].remove(treeToRemove);
            }
            ++d3;
        }
        log = String.valueOf(log) + "Each set of tree of depth d>1 are randomly reduced to " + Parameters.maxTreesInDepth;
        FileUtil.appendReturn(log, Parameters.logFile);
        return ETreesDepth;
    }

    private void toPCFG() {
        Hashtable[] ETreesDepth = this.sortTreesAndFilter();
        int uniqueLableIndex = 0;
        int d = 0;
        while (d < Parameters.maxDepth) {
            Enumeration e = ETreesDepth[d].keys();
            while (e.hasMoreElements()) {
                String eTree = (String)e.nextElement();
                Integer count = (Integer)ETreesDepth[d].get(eTree);
                TSNode TN = new TSNode(eTree, false);
                TN.toNormalForm();
                uniqueLableIndex = TN.toUniqueInternalLabels(false, uniqueLableIndex, false);
                List<TSNode> nonLexicalNodes = TN.collectNonTerminalNodes();
                for (TSNode nonTerminal : nonLexicalNodes) {
                    boolean prelexical = nonTerminal.isPrelexical();
                    Hashtable toAdd = prelexical ? this.lexRules : this.internalRules;
                    String rule = nonTerminal.toCFG(false);
                    Utility.increaseStringInteger(toAdd, rule, 1);
                }
            }
            ++d;
        }
        String log = "Converted trees to PCFG. \n # Internal Rules: " + this.internalRules.size() + "\n # Lex Rules: " + this.lexRules.size();
        FileUtil.appendReturn(log, Parameters.logFile);
    }

    public static void main(String[] args) {
        throw new Error("Unresolved compilation problem: \n\tThe constructor Parser(DOP_MaxDepth) is undefined\n");
    }
}

