#!/bin/bash
dev=$1
fewshot_model=$2
fewshot_bit=$3
fewshot_dtype=$4
qeft_command=$5
load_path=$6
fewshot_path=$7

if [ "$fewshot_model" == "13b" ]
then
    CUDA_VISIBLE_DEVICES=$dev python qeft_finetune.py $qeft_command
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-13b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks hendrycksTest-* --no_cache --batch_size auto --num_fewshot 5 --ctx_reuse --output_path $fewshot_path-mmlu.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-13b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks hellaswag --no_cache --batch_size auto --num_fewshot 10 --ctx_reuse --output_path $fewshot_path-hellaswag.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-13b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks arc_challenge --no_cache --batch_size auto --num_fewshot 25 --output_path $fewshot_path-arc.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-13b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks truthfulqa_mc --no_cache --batch_size auto --output_path $fewshot_path-truthfulqa.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-13b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks winogrande --no_cache --batch_size auto --num_fewshot 5 --output_path $fewshot_path-winogrande.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-13b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks gsm8k --no_cache --batch_size 1 --num_fewshot 5 --output_path $fewshot_path-gsm8k.json
    python qeft_utils/score_print.py --file $fewshot_path
fi

if [ "$fewshot_model" == "7b" ]
then
    CUDA_VISIBLE_DEVICES=$dev python qeft_finetune.py $qeft_command
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-7b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks hendrycksTest-* --no_cache --batch_size auto --num_fewshot 5 --ctx_reuse --output_path $fewshot_path-mmlu.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-7b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks hellaswag --no_cache --batch_size auto --num_fewshot 10 --ctx_reuse --output_path $fewshot_path-hellaswag.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-7b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks arc_challenge --no_cache --batch_size auto --num_fewshot 25 --output_path $fewshot_path-arc.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-7b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks truthfulqa_mc --no_cache --batch_size auto --output_path $fewshot_path-truthfulqa.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-7b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks winogrande --no_cache --batch_size auto --num_fewshot 5 --output_path $fewshot_path-winogrande.json
    CUDA_VISIBLE_DEVICES=$dev python lm-evaluation-harness/main.py --model hf-causal-experimental-owq --model_args pretrained=meta-llama/Llama-2-7b-hf,dtype="$fewshot_dtype",load=$load_path/model.pth,wbits=$fewshot_bit,faster=True --tasks gsm8k --no_cache --batch_size 1 --num_fewshot 5 --output_path $fewshot_path-gsm8k.json
    python qeft_utils/score_print.py --file $fewshot_path
fi