import os
import myutils
import json
import conll18_ud_eval

if not os.path.isdir('results'):
    os.mkdir('results/')

def conv(score):
    if type(score) == float:
        return '{:.4f}'.format(score*100)
    else:
        return score

tasks= ['Tokens', 'LAS', 'UFeats', 'UPOS', 'Lemmas']
def eval(udVersion, outName, model, setting):
    outFiles = {}
    for task in tasks:
        outFiles[task] = open('results/' + task + '.' + outName + '-' + model.split('.')[1] + '-' + udVersion + '.csv', 'w')

    ## single-dataset models
    fScores = {}
    for task in tasks:
        fScores[task] = []
    treebanks = []
    udPath = 'data/ud-treebanks-v' + udVersion + '.singleToken/'
    for UDdir in sorted(os.listdir(udPath)):
        if not UDdir.startswith("UD") or not os.path.isdir(udPath + UDdir):
            continue
        train, dev, test = myutils.getTrainDevTest(udPath + UDdir)
        
        if dev == '':
            continue
        if not myutils.hasColumn(train, 1, threshold=.1):
            #print('noWords ', train)
            continue
        treebanks.append(UDdir)

        if UDdir in myutils.hasNoSplits and setting.endswith('True') and 'attention' not in outName:
            for task in tasks:
                fScores[task].append('---')
            continue

        if model.startswith('multi.'):
            modelName = model + '.' + setting + '.' + udVersion
            modelName = modelName.replace('..', '.')
            modelPath = myutils.getModel(modelName)
            outPath = modelPath.replace('model.pt', UDdir + '.out')
        else:
            modelName = model + '.' + UDdir + '.' + setting + '.' + udVersion
            if modelName[-1] == '.':
                modelName = modelName[:-1]
            modelName = modelName.replace('..', '.')
            modelPath = myutils.getModel(modelName) 
            if modelPath == '':
                print('model not found', modelName)
                for task in tasks:
                    fScores[task].append('---')
                continue
            outPath = modelPath.replace('model.pt', UDdir + '.out')
        if outName == 'single-task':
            cmd = 'python3 scripts/fix.py ' + outPath
            os.system(cmd)

        print(dev, outPath, flush=True)
        try:
            goldSent = conll18_ud_eval.load_conllu(open(dev))
            predSent = conll18_ud_eval.load_conllu(open(outPath))
            scores = conll18_ud_eval.evaluate(goldSent, predSent)
            for task in tasks:
                fScores[task].append(scores[task].f1)

        except:
            for task in tasks:
                fScores[task].append('---')
            print("ERROR in " + outPath)

    for task in tasks:
        for treebank, score in zip(treebanks, fScores[task]):
            outFiles[task].write('\t'.join([treebank] + [conv(score)]) + '\n')
    for outFile in outFiles:
        outFiles[outFile].close()    

for mlm in myutils.mlms:
    for udVersion in myutils.udVersions:
        eval(udVersion, 'multi-task', 'tok.' + mlm, 'False.False') # multi-task without new splits
        eval(udVersion, 'single-task', 'tok.' + mlm, 'single') # single task 
        eval(udVersion, 'multi-task+split', 'tok.' + mlm, 'True.False') # multi-task with new splits
        eval(udVersion, 'multi-task+split+attention', 'tok.' + mlm, 'True.True') # multi-task with new splits and layer attention
        eval(udVersion, 'multi-ling', 'multi.' + mlm, 'False') # multi-lingual, multi-task
        eval(udVersion, 'multi-ling+split', 'multi.' + mlm, 'True') # multi-lingual, multi-task  with new splits
        eval(udVersion, 'gold', 'notok.' + mlm, '')



