import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np

sns.set_theme()

N = 8
ind = np.arange(N)
width = 0.25

labels = ["Coherence-KD",
          "Consistency-KD",
          "Fluency-KD",
          "Relevance-KD",
          "Coherence-SP",
          "Consistency-SP",
          "Fluency-SP",
          "Relevance-SP",
          ]

original = [
    0.25,
    0.483,
    0.367,
    0.45,
    0.359,
    0.703,
    0.503,
    0.594
]

bmx = [
    0.3,
    0.5,
    0.383,
    0.533,
    0.412,
    0.709,
    0.535,
    0.665
]

fine_tuned = [
    0.33333333333333337,
    0.26666666666666666,
    0.21666666666666667,
    0.33333333333333337,
    0.4323529411764706,
    0.4823529411764706,
    0.31176470588235294,
    0.4205882352941176
]

sns.set(rc={'figure.figsize': (3.5, 2.0)})
bar1 = plt.bar(ind, original, width, color = 'b')
bar2 = plt.bar(ind+width, fine_tuned, width, color = 'r')
bar3 = plt.bar(ind+width*2, bmx, width, color = 'g')

plt.ylabel('Correlation', fontsize= 8)

plt.xticks(ind + width, labels, rotation = 35, ha="right")
plt.legend((bar1, bar2, bar3), ["Original", "Tuned", "BMX"], prop={'size': 8})
plt.tick_params(axis='both', which='major', labelsize=8)

plt.tight_layout()
plt.savefig("Compare_tuned.pdf")
plt.show()
