import pandas as pd

def _preprocess(text):
    text = text.replace('\n-',', ')
    text = text.replace('\n',', ')
    text = text.replace('{','').replace('}','')
    return text

def _mapping(feature, text):
    if feature == 'Identity':
        if text.lower() == 'other known adult' or text.lower() == 'unknown person':
            text = 'An ' + text.lower() + ' of the abused'
        elif text.lower() == 'other':
            text = 'Someone'
        else:
            text = 'A '+text.lower()
        return text

    if feature == 'Needs':
        if text == 'Not clear':
            text = "'s needs are unclear"
        text = text.lower().replace('seeking resources', 'seeks resources')
        text = text.replace('getting emotional support', 'wants emotional support')
        text = text.replace('getting advice about the situation', 'needs advice')
        text = text.replace('reporting the situation', 'wants to report')
        return text

    if feature == 'Perpetrator':
        if text.lower()=='other':
            text = 'someone'
        return text.lower() + ' of the abused'
    
    if feature == 'Offers':
        if text.lower() == 'not clear':
            return "it's not clear what the counselor offers"
        else:
            return "focuses on " + text.lower()
    
    if feature == 'Tried':
        if text.lower() == 'none' or text.lower() == 'others':
            return "It's not clear what the help seeker has tried to resolve the situation"
        else:
            return "The help seeker tried " + text.lower() + " to resolve the situation"

    if feature == 'Solution':
        if text.lower() == 'none' or text.lower() == 'others':
            return "it's not clear what the counselor suggests"
        else:
            return "the counselor suggests " + text.lower()

    if feature == 'HelpSeeker':
        if text.lower() == 'no':
            return "There's no clear evidence of the help seeker showing negative reaction."
        elif text.lower() == 'yes':
            return "In the chat, the help seeker shows negative reaction."
        else:
            return text

    if feature == 'Counselor':
        if text.lower() == 'none':
            return "Throughout the chat, the counselor shows very good attitude."
        else:
            return "The counselor's attitude seems to be " + text.lower() + " in the conversation."
        

def format_features(df):
    _dict = {}
    for idx, row in df.iterrows():
        _dict[row['feature']] = _preprocess(row['answer'])

    explanation = f"{_mapping('Identity',_dict['Identity'])} "
    explanation += f"{_mapping('Needs', _dict['Needs'])} regarding the situation where there has been "
    explanation += f"{_dict['Type'].lower()} "
    explanation += f"({_dict['Severity'].lower()}) "
    explanation += f"by {_mapping('Perpetrator', _dict['Perpetrator'])}. "
    explanation += f"The counselor explores the issue with {_dict['Strategy'].lower()} and "
    explanation += f"{_mapping('Offers', _dict['Offers'])}. "
    explanation += f"{_mapping('Tried', _dict['Tried'])} and "
    explanation += f"{_mapping('Solution', _dict['Solution'])}. "
    explanation += f"About the suggestion, the help seeker is {_dict['Reaction'].lower()}. "
    explanation += f"{_mapping('HelpSeeker', _dict['HelpSeeker'])} "
    explanation += f"{_mapping('Counselor', _dict['Counselor'])}"
    return explanation

def convert_data(data_df, code_df, feat_df, summary_df, objsummary_df,
                IS_BINARY, NUM_TURNS, OUTPUT_LABEL, SEP_TOKEN,
                USE_CONV, USE_CODE, USE_FEATURE, USE_SUMMARY, USE_OBJECTIVE):

    id_list, text_list, label_list, feat_list = [], [], [], []
    binary_mapping = {0:0, 1:1, 2:1}
    for idx, row in data_df.iterrows():
        id_list.append(row['id'])

        if IS_BINARY:
            if USE_CONV and (USE_FEATURE or USE_SUMMARY):
                _label = [0]*2
                _label[binary_mapping[row[OUTPUT_LABEL]]] = 1
                label_list.append(_label)
            else:
                label_list.append(binary_mapping[row[OUTPUT_LABEL]])
        else:
            if USE_CONV and (USE_FEATURE or USE_SUMMARY):
                _label = [0]*3
                _label[row[OUTPUT_LABEL]] = 1
                label_list.append(_label)
            else:
                label_list.append(row[OUTPUT_LABEL])

        feat_text = ''
        if USE_FEATURE:
            feat_text += format_features(feat_df[feat_df['id']==row['id']]) + '\n'
        if USE_SUMMARY:
            if USE_OBJECTIVE:
                feat_text += objsummary_df[objsummary_df['id']==row['id']]['answer'].tolist()[0]
            else:
                feat_text += summary_df[summary_df['id']==row['id']]['answer'].tolist()[0]
        feat_list.append(feat_text)

        if USE_CONV:
            _text_list = row['text'].split('\n')
            if USE_CODE:
                _indicator = code_df[code_df['id']==row['id']]['indicator'].tolist()[0]
                feature_indicator_list = [elem.split(',') for elem in _indicator.split('___')]
                feature_added_text_list = []
                for j, elem in enumerate(_text_list):
                    _feature = ''
                    if '1' in feature_indicator_list[j]:
                        _feature += '[Emotional] '
                    if '2' in feature_indicator_list[j]:
                        _feature += '[Factual] '
                    if '3' in feature_indicator_list[j] or '4' in feature_indicator_list[j]:
                        _feature += '[Solution] '
                    
                    feature_added_text_list.append(elem.split('___')[1] + ': ' + _feature + '___'.join(elem.split('___')[2:]))
                _text_list = feature_added_text_list

            if len(_text_list) <= NUM_TURNS*2:
                focus_text = SEP_TOKEN.join(_text_list)
                
            else:
                focus_text_list = _text_list[:NUM_TURNS]
                focus_text_list += _text_list[-NUM_TURNS:]
                focus_text = SEP_TOKEN.join(focus_text_list)
            text_list.append(focus_text)
        else:
            text_list.append(feat_text)

    return pd.DataFrame(data={'id': id_list, 'text':text_list, 'label':label_list, 'feature':feat_list})

def combine_codes(df1, df2):
    df1.drop(columns=['indicator_abst', 'indicator_seeker', 'indicator_lower'], inplace=True)
    df2.drop(columns=['informative', 'prepared'], inplace=True)
    _dict = {'id':[],'text':[],'positive':[],'indicator':[]}
    for idx, row in df2.iterrows():
        if row['id'] in df1['id'].tolist():
            minidf = df1[df1['id']==row['id']]
            _dict['indicator'].append(minidf['indicator'].tolist()[0])
        else:
            _dict['indicator'].append(row['indicator'])
        _dict['id'].append(row['id'])
        _dict['text'].append(row['text'])
        _dict['positive'].append(row['positive'])
    return pd.DataFrame(data=_dict)