import json
import random
from transformers import CLIPProcessor, CLIPModel


model = CLIPModel.from_pretrained('../models/clip-vit-base-patch16')
processor = CLIPProcessor.from_pretrained('../models/clip-vit-base-patch16')

with open('../nobj_tokens.json','r',encoding='utf-8') as f:
    token_list = json.load(f)

tokens = [x for s in token_list for x in s if x!=49406 and x!=49407]

prompts = []
for _ in range(1000):
    length = len(random.choice(token_list))
    new_seq = random.choices(tokens, k=length-2)
    text = processor.decode(new_seq)
    prompts.append(text)

with open('random_prompts.json', 'w', encoding='utf-8') as f:
    json.dump(prompts, f)
