theory question_67_8
imports Main

begin

typedecl entity
typedecl event

consts
  Participant :: "entity ⇒ event ⇒ bool"
  OnBoat :: "entity ⇒ event ⇒ bool"
  RiverBoatTour :: "entity ⇒ event ⇒ bool"
  Older :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Together :: "entity ⇒ entity ⇒ bool"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "Older x ∧ Older y ∧ Male x ∧ Male y ∧ Together x y ∧ Participant x RiverBoatTour z  ∧ Participant y RiverBoatTour z"
  (* Hypothesis: Two males sitting together on a boat. *)
  shows "∃x y e. Male x ∧ Male y ∧ Together x y ∧ OnBoat e x ∧ OnBoat e y"
proof -
  from asm have "Participant x RiverBoatTour z" by blast
  then have "OnBoat x z" using explanation_1 by blast
  from asm have "Participant y RiverBoatTour z" by blast
  then have "OnBoat y z" using explanation_1 by blast
  from asm have "Male x" by blast
  from asm have "Male y" by blast
  show ?thesis using `Male x` `Male y` `OnBoat x z` `OnBoat y z` `Together x y` by blast
qed

end
