theory question_81_6

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  PopulationSize :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Reduce :: "event ⇒ bool"
  Sudden :: "event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ PopulationSize y ⟶ (∃e1. Cause e1 ∧ Agent e1 x ∧ Patient e1 e2) ∧ (∃e2. Reduce e2 ∧ Agent e2 e1 ∧ Patient e2 y ∧ Sudden e2)"

(* Explanation 2: If a sudden reduction in the population size of a specific entity occurs, then the bottleneck effect occurs in that entity. *)
axiomatization where
  explanation_2: "∀x y e. Entity x ∧ PopulationSize y ∧ Reduce e ∧ Agent e y ∧ Patient e x ∧ Sudden e ⟶ (∃e'. BottleneckEffect e' ∧ Occur e' ∧ Agent e' x)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  {
    assume "ExternalMigration x"
    then obtain e1 e2 where e1: "Cause e1 ∧ Agent e1 x ∧ Patient e1 e2"
      and e2: "Reduce e2 ∧ Agent e2 e1 ∧ Patient e2 y ∧ Sudden e2"
      using explanation_1 by blast
    from e2 have "Reduce e2 ∧ Agent e2 e1 ∧ Patient e2 x ∧ Sudden e2"
      using e1 by auto
    then obtain e' where "BottleneckEffect e' ∧ Occur e' ∧ Agent e' x"
      using explanation_2 by blast
  }
  then show ?thesis by blast
qed

end
