theory question_17_8
imports Main
begin
typedecl entity
typedecl event
typedecl trophic_level
consts
  Omnivores :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Plants :: "entity ⇒ bool"
  TrophicLevel :: "trophic_level ⇒ bool"
  Producer :: "entity ⇒ bool"
  First :: "trophic_level ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TrophicLevelOf :: "entity ⇒ trophic_level ⇒ bool"
  Consumers :: "entity ⇒ bool"
  HigherThan :: "trophic_level ⇒ trophic_level ⇒ bool"
  Different :: "trophic_level ⇒ trophic_level ⇒ bool"

(* Explanation 1: Omnivores feed on plants, which are producers at the first trophic level. *)
axiomatization where
  explanation_1: "∀x e p t. Omnivores x ∧ Feed e ∧ Plants p ∧ TrophicLevel t ∧ Producer p ∧ First t ∧ Agent e x ∧ Patient e p ∧ TrophicLevelOf p t"

(* Explanation 2: Omnivores also feed on consumers that are at various trophic levels higher than the first. *)
axiomatization where
  explanation_2: "∀x e c t1 t2. Omnivores x ∧ Feed e ∧ Consumers c ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ HigherThan t1 First ∧ Agent e x ∧ Patient e c ∧ TrophicLevelOf c t1 ∧ Different t1 t2"

(* Explanation 3: Omnivores feed at multiple trophic levels, specifically the first and at least one higher level. *)
axiomatization where
  explanation_3: "∀x e1 e2 t1 t2. Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Patient e1 t1 ∧ Agent e2 x ∧ Patient e2 t2 ∧ First t1 ∧ HigherThan t2 t1 ∧ Different t1 t2"

theorem hypothesis:
  assumes asm: "Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Patient e1 t1 ∧ Agent e2 x ∧ Patient e2 t2"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "Different t1 t2"
proof -
  from asm have "Omnivores x" by simp
  from asm have "Feed e1" by simp
  from asm have "Feed e2" by simp
  from asm have "Agent e1 x" by simp
  from asm have "Patient e1 t1" by simp
  from asm have "Agent e2 x" by simp
  from asm have "Patient e2 t2" by simp

  {
    assume "Plants p" "Producer p" "First t1" "TrophicLevelOf p t1"
    from explanation_1[OF this] have "Feed e3" "Agent e3 x" "Patient e3 p" by blast
    with asm have "Feed e1" "Feed e3" "Agent e1 x" "Agent e3 x" "Patient e1 t1" "Patient e3 p" by simp
    with explanation_3 have "Different t1 t2" by blast
  }

  {
    assume "Consumers c" "TrophicLevel t1" "TrophicLevel t2" "HigherThan t1 First" "TrophicLevelOf c t1" "Different t1 t2"
    from explanation_2[OF this] have "Feed e4" "Agent e4 x" "Patient e4 c" by blast
    with asm have "Feed e2" "Feed e4" "Agent e2 x" "Agent e4 x" "Patient e2 t2" "Patient e4 c" by simp
    with explanation_3 have "Different t1 t2" by blast
  }

  then show ?thesis using asm by blast
qed

end
