theory question_64_0

imports Main

begin
typedecl entity
typedecl event

consts
  FoodVendor :: "entity ⇒ bool"
  Food :: "entity ⇒ bool"
  Serves :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  People :: "entity ⇒ bool"
  Line :: "entity ⇒ bool"
  Stand :: "event ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"
  Waiting :: "event ⇒ bool"
  By :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A food vendor serves food. *)
axiomatization where
  explanation_1: "∃x y e. FoodVendor x ∧ Food y ∧ Serves e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: People are waiting in line by a food vendor. *)
  assumes asm: "People x ∧ Line y ∧ FoodVendor z ∧ Waiting e ∧ Agent e x ∧ In e y ∧ By e z"
  (* Hypothesis: People stand in line for food. *)
  shows "∃x y e. People x ∧ Line y ∧ Food y ∧ Stand e ∧ Agent e x ∧ In e y"
proof -
  from asm have "People x ∧ Line y ∧ Waiting e ∧ Agent e x ∧ In e y" by blast
  from explanation_1 have "Food y ∧ Stand e ∧ Agent e x ∧ In e y" by blast
  then show ?thesis using asm `People x` `Line y` `Food y` `Stand e` `Agent e x` `In e y` by blast
qed

end
