#!/bin/bash
set -e
# cudaNum=0,1 (Incase if you have multiple GPUs)
cudaNum=$1

# Mention Any BEIR dataset here (which has been preprocessed)
export dataset=$2 
export experiment_name=$3

echo "################ SETTINGS ################"
echo "RUNNING: FEWSHOT - ELITE - WO - DI"
echo "cudaNum:         ${cudaNum}"
echo "dataset:         ${dataset}"
echo "experiment_name: ${experiment_name}"
echo "##########################################"

# Path to store the faiss index and run output
export INDEX_ROOT="indices_v2"
export OUTPUT_DIR="output"

# Num of partitions in for IVPQ Faiss index (You must decide yourself)
if [ "$dataset" = "nfcorpus" ]; then
  export NUM_PARTITIONS=96
elif [ "$dataset" = "trec-covid-v2" ]; then
  export NUM_PARTITIONS=865
elif [ "$dataset" = "webis-touche2020" ]; then
  export NUM_PARTITIONS=10240
elif [ "$dataset" = "fiqa" ]; then
  export NUM_PARTITIONS=2048
elif [ "$dataset" = "scidocs" ]; then
  export NUM_PARTITIONS=2048
elif [ "$dataset" = "scifact" ]; then
  export NUM_PARTITIONS=128
elif [ "$dataset" = "arguana" ]; then
  export NUM_PARTITIONS=256
fi

# Some Index Name to store the faiss index
export INDEX_NAME=$(echo $dataset | tr '[:lower:]' '[:upper:]')

# Path to store the rankings file
export EPISODE_DIR="colbert-datasets/${experiment_name}/${dataset}"

export QUERIES="${EPISODE_DIR}/queries-ep1.tsv"
export EXPANSION="/home/some_user/di_w_kmeans_idf_tokens/${dataset}/depth3.n_clusters24.n_expansions10/expansion.pt"
########################################################################################
# 3. Intent LLM: Generate refined query by figuring out the latent intent of the query #
########################################################################################
echo "####################### INTENT LLM #######################"
python -m colbert.elite_fewshot_wo_di \
    --dataset_name ${dataset} \
    --new_queries ${QUERIES} \
    --new_queries_intents "${EPISODE_DIR}/queries-intent-ep${ep_num}.tsv" \
    --prf_terms "prf_terms/di_w_kmeans_idf_tokens/${dataset}/depth3.n_clusters24.n_expansions10/prf_words.json" \
    --expansion ${EXPANSION} \
    --everything "${EPISODE_DIR}/everything-ep${ep_num}.jsonl" \
    --everything_step "${EPISODE_DIR}/everything_step-ep${ep_num}.jsonl"
