# 8월 버전입니다. 추후 사용할 때 수정할 예정입니다.
def cor_test(column1: NumColumn, column2: NumColumn):

    # version 1
    n_block = Block.zeros(column1.context)
    for vbit_block1, vbit_block2 in zip(column1.vbit, column2.vbit):
        n_block += vbit_block1 * vbit_block2
    n_block = __rotate_sum(n_block)

    r_block = correlation(column1, column2)

    r2_block = r_block * r_block
    if r2_block.need_bootstrap(5):
        r2_block.bootstrap(one_slot=True)

    denom_block = Block.ones(column1.context) - r2_block
    denom_block = denom_block.sqrt_inv(one_slot=True)

    n_minus_2_block_resize = (n_block - Block.ones(column1.context) * 2) * (1 / column1.num_rows)
    n_minus_2_block_resize_sqrt = n_minus_2_block_resize.sqrt(one_slot=True)
    n_minus_2_block_sqrt = n_minus_2_block_resize_sqrt * math.sqrt(column1.num_rows)

    res_block = r_block * n_minus_2_block_sqrt
    if res_block.need_bootstrap(5):
        res_block.bootstrap()
    res_block *= denom_block
