/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import utils_bk.StringUtils;

public class T_test {
    public static String paired_t_test(double[] data) {
        double t = 0.0;
        double two_tail = -1.0;
        boolean significant = false;
        int count = data.length;
        if (count != 10) {
            System.err.println("Paired t-test only for 10 samples...");
            System.exit(0);
        }
        double mean = 0.0;
        for (int fold = 0; fold < 10; ++fold) {
            mean += data[fold];
        }
        mean /= (double)count;
        double variance = 0.0;
        for (int fold = 0; fold < 10; ++fold) {
            variance += Math.pow(data[fold] - mean, 2.0);
        }
        double stdev = Math.sqrt(variance /= (double)count);
        t = (mean - 0.0) / (stdev / Math.sqrt(count));
        if (t >= 1.38) {
            two_tail = 0.2;
            significant = true;
        }
        if (t >= 1.83) {
            two_tail = 0.1;
        }
        if (t >= 2.26) {
            two_tail = 0.05;
        }
        if (t >= 3.25) {
            two_tail = 0.001;
        }
        String output = "mean=" + StringUtils.twoDecPosS(mean) + " stdev=" + StringUtils.twoDecPosS(stdev) + " t=" + StringUtils.twoDecPosS(t) + " two_tail=" + two_tail + " one_tail=" + StringUtils.twoDecPosS(two_tail / 2.0) + " confidence>95=" + significant;
        return output;
    }

    public static String latex_t_test(String ttest) {
        String tout = "";
        String[] ttestarr = ttest.trim().split(" ");
        if (Double.parseDouble(ttestarr[0].substring(5)) < 0.0) {
            tout = "negative";
        } else if (ttest.endsWith("false")) {
            tout = ttestarr[2].substring(2) + " (not-sg)";
        }
        if (tout.equals("")) {
            String p = ttestarr[4].substring(9);
            if (p.equals("0.00")) {
                p = p + "5";
            }
            tout = ttestarr[2].substring(2) + " (" + p + ")";
        }
        String output = ttestarr[0].substring(5) + " \t& " + ttestarr[1].substring(6) + " \t\t& " + tout + "\\\\";
        return output;
    }
}

