/*
 * Decompiled with CFR 0.152.
 */
package nlp_files;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import nlp_files.NLPFile;
import org.xml.sax.XMLReader;
import utils_bk.FileUtils;
import xml_parsers.SimpleErrorHandler;
import xml_parsers.Xml2PlainHandler;

public class XMLFile
extends NLPFile {
    private String xsd = null;

    public Boolean isWellFormed() {
        try {
            File xsd_file;
            if (!super.isLoaded().booleanValue()) {
                throw new Exception("No file loaded in NLPFile object");
            }
            if (!this.extension.matches("\\s*") && (xsd_file = new File(FileUtils.getApplicationPath() + FileUtils.NLPFiles_descr_path + this.extension + ".xsd")).exists() && xsd_file.isFile()) {
                this.xsd = xsd_file.getCanonicalPath();
            }
            if (!this.SAXParserCheck(this.f).booleanValue()) {
                System.err.println("Malformed XML (SAX)");
                return false;
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return false;
        }
        return true;
    }

    public Boolean SAXParserCheck(File f) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            if (this.xsd != null) {
                if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                    System.err.println("Validating " + f.getName() + " with xsd (" + this.xsd + ")");
                }
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource(this.xsd)}));
            }
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setErrorHandler(new SimpleErrorHandler());
            reader.parse(f.getCanonicalPath());
            return true;
        }
        catch (Exception e) {
            System.err.println("Errors found (XMLFile):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return false;
        }
    }

    public Boolean DOMParserCheck(File f) {
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            parser.setErrorHandler(new SimpleErrorHandler());
            parser.parse(f.getCanonicalPath());
            return true;
        }
        catch (Exception e) {
            System.err.println("Errors found (XMLFile):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return false;
        }
    }

    public String getStats(String parameters) {
        return "Not implemented yet.";
    }

    public String detectLanguage() {
        return "en";
    }

    public String toPlain() {
        try {
            String plainfile = this.getFile().getCanonicalPath() + ".plain";
            Xml2PlainHandler xml2plain = new Xml2PlainHandler();
            xml2plain.saveFile(this.f.getCanonicalPath(), plainfile);
            return plainfile;
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return null;
        }
    }

    public String pair2plain(String plainmodel) {
        return null;
    }

    public String merge_tok_n_xml(String xmlfile, String root_tag, String tags_re, String attrs_re) {
        return null;
    }
}

