# -*- coding: utf-8 -*-

import re


def camel_to_snake(name):
    name = re.sub('(.)([A-Z][a-z]+)', r'\1_\2', name)
    name = re.sub('([a-z0-9])([A-Z])', r'\1_\2', name).lower()
    return name


def snake_to_camel(name):
    return ''.join(map(str.capitalize, name.split('_')))
