/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BasicPatterns {
    public static final String C = "[bcdfghjklmnpqrstvwxyz]";
    public static final String V = "[aeiou]";
    public static final String VL = "[lraeiou]";
    public static final String VY = "[yaeiou]";
    public static final String VX = "[xaeiou]";
    public static final String ANY_STEM = "^(([a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)(-[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)*)(\\s(([a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)(-[a-zA-Z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df_0-9]+)*))*$";
    public static final String SYLLABLE = "(([bcdfghjklmnpqrstvwxyz]{1,3})([yaeiou]+)([bcdfghjklmnpqrstvwxyz]{0,2}))";
    public static final String SYLLABLE_Y = "(([bcdfghjklmnpqrstvwxyz]{1,3})y)";
    public static final String SYLLABLE_E = "(([bcdfghjklmnpqrstvwxyz]{1,3})e)";
    public static final String VERBAL_PREFIX = "((be|with|pre|un|over|re|mis|under|out|up|fore|for|counter|co|sub)(-?))";
    public static final String LAST_VOWEL = "(Au|Aa|au|aa|[aouAOU])[^aouAOU]*$";

    public static final String applyStemUmlaut(String word) {
        Pattern p = Pattern.compile(LAST_VOWEL);
        Matcher m = p.matcher(word);
        StringBuilder s = new StringBuilder(word);
        if (m.find()) {
            s.replace(m.start(1), m.end(1), BasicPatterns.createUmlaut(m.group(1)));
        }
        return s.toString();
    }

    private static final String createUmlaut(String vowel) {
        String umlaut = vowel;
        if (vowel.equals("a")) {
            umlaut = "\u00e4";
        } else if (vowel.equals("A")) {
            umlaut = "\u00c4";
        } else if (vowel.equals("o")) {
            umlaut = "\u00f6";
        } else if (vowel.equals("O")) {
            umlaut = "\u00d6";
        } else if (vowel.equals("u")) {
            umlaut = "\u00fc";
        } else if (vowel.equals("U")) {
            umlaut = "\u00dc";
        } else if (vowel.equals("au")) {
            umlaut = "\u00e4u";
        } else if (vowel.equals("Au")) {
            umlaut = "\u00c4u";
        } else if (vowel.equals("aa")) {
            umlaut = "\u00e4";
        } else if (vowel.equals("Aa")) {
            umlaut = "\u00c4";
        }
        return umlaut;
    }
}

