/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import simplenlg.aggregation.EllipsisRule;
import simplenlg.features.DiscourseFunction;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.StringPhraseSpec;

public class PhraseSet {
    private DiscourseFunction function;
    private List<Phrase> phrases;
    List<EllipsisRule> leftMarkers;
    List<EllipsisRule> rightMarkers;

    public PhraseSet(DiscourseFunction function, Phrase ... phrases) {
        this.function = function;
        this.phrases = new ArrayList<Phrase>(Arrays.asList(phrases));
    }

    public void addPhrase(Phrase phrase) {
        this.phrases.add(phrase);
    }

    public void addPhrases(Collection<Phrase> phrases) {
        this.phrases.addAll(phrases);
    }

    public DiscourseFunction getFunction() {
        return this.function;
    }

    public void elideRightmost() {
        for (int i = 1; i < this.phrases.size(); ++i) {
            Phrase phrase = this.phrases.get(i);
            if (phrase == null) continue;
            phrase.setElided(true);
        }
    }

    public void elideLeftmost() {
        for (int i = this.phrases.size() - 2; i >= 0; --i) {
            Phrase phrase = this.phrases.get(i);
            if (phrase == null) continue;
            phrase.setElided(true);
        }
    }

    public boolean lemmaIdentical() {
        boolean ident = !this.phrases.isEmpty();
        for (int i = 1; i < this.phrases.size() && ident; ++i) {
            Phrase left = this.phrases.get(i - 1);
            Phrase right = this.phrases.get(i);
            if (left == null || right == null) continue;
            if (left instanceof StringPhraseSpec) {
                ident = ((StringPhraseSpec)left).getString().equals(((StringPhraseSpec)right).getString());
                continue;
            }
            if (!(left instanceof HeadedPhraseSpec)) continue;
            ident = ((HeadedPhraseSpec)left).getHead().equals(((HeadedPhraseSpec)right).getHead());
        }
        return ident;
    }

    public boolean formIdentical() {
        boolean ident = !this.phrases.isEmpty();
        for (int i = 1; i < this.phrases.size() && ident; ++i) {
            Phrase left = this.phrases.get(i - 1);
            Phrase right = this.phrases.get(i);
            if (left == null || right == null) continue;
            if (left instanceof StringPhraseSpec) {
                ident = ((StringPhraseSpec)left).getString().equals(((StringPhraseSpec)right).getString());
                continue;
            }
            if (!(left instanceof HeadedPhraseSpec)) continue;
            ident = ((HeadedPhraseSpec)left).equals(right);
        }
        return ident;
    }
}

