#include "model.ih"

void Model::addNgrams(NGram *langModel)
{
    for (size_t candIdx = 0; candIdx != d_cands[d_wordIdx].size(); ++candIdx)
    {
        string cand = d_cands[d_wordIdx][candIdx];
        string prevWord = (d_wordIdx == 0)? "<S>": d_origs[d_wordIdx-1];
        string nextWord = (d_wordIdx == d_origs.size() - 1)? "</S>": 
                            d_origs[d_wordIdx+1];

        double curCandCount = double(langModel->getCount(cand) + 1);
        uint64_t prevCount = langModel->getCount(prevWord, cand);
        uint64_t nextCount = langModel->getCount(cand, nextWord);
        
        //cout << prevWord << ' ' << cand << ' ' << nextWord << '\t' << prevCount << '\t' << curCandCount << '\t' << nextCount << '\n';
        //cout << prevCount /curCandCount << '\t' << nextCount / curCandCount << '\n' << '\n';
        
        d_featVals[d_wordIdx][candIdx * d_config->numFeats + d_featIdx] = curCandCount; // / langModel->getTotalCount();
        d_featVals[d_wordIdx][candIdx * d_config->numFeats + d_featIdx + 1] = prevCount / curCandCount;
        d_featVals[d_wordIdx][candIdx * d_config->numFeats + d_featIdx + 2] = nextCount / curCandCount;
    }
}
