/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.pku.coli.io.CCGPARGWriter;
import edu.pku.coli.io.CoNLLReader;
import edu.pku.coli.pear.dag.Evaluator;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.tran.AbstractAction;
import edu.pku.coli.pear.dag.tran.CoordinationUnionAction;
import fig.basic.Pair;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultilanguageTest {
    static Map<String, String> pathMap = new HashMap<String, String>();
    static String _ArabicPath = "E:\\conll07st\\arabic\\PADT\\train\\arabic_PADT_train.conll";
    static String _BasquePath = "E:\\conll07st\\basque\\3lbBasque\\train\\basque_3lbBasque_train.conll";
    static String _CatalanPath = "E:\\conll07st\\catalan\\cess-cat\\train\\catalan_cess-cat_train.conll";
    static String _ChinesePath = "E:\\conll07st\\chinese\\sinica\\train\\chinese_sinica_train.conll";
    static String _CzechPath = "E:\\conll07st\\czech\\pdt\\train\\czech_pdt_train.conll";
    static String _EnglishPath = "E:\\conll07st\\english_train\\ptb\\train\\english_ptb_train.conll";
    static String _GreekPath = "E:\\conll07st\\greek\\gdt\\train\\greek_gdt_train.conll";
    static String _HungarianPath = "E:\\conll07st\\hungarian\\szegedtreebank\\train\\hungarian_szegedtreebank_train.conll";
    static String _ItalianPath = "E:\\conll07st\\italian\\isst\\train\\italian_isst_train.conll";
    static String _TurkishPath = "E:\\conll07st\\turkish\\metu_sabanci\\train\\turkish_metu_sabanci_train.conll";

    public static void main(String[] args) {
        pathMap.put("Arabic", _ArabicPath);
        pathMap.put("Basque", _BasquePath);
        pathMap.put("Catalan", _CatalanPath);
        pathMap.put("Chinese", _ChinesePath);
        pathMap.put("Czech", _CzechPath);
        pathMap.put("English", _EnglishPath);
        pathMap.put("Greek", _GreekPath);
        pathMap.put("Hungarian", _HungarianPath);
        pathMap.put("Italian", _ItalianPath);
        pathMap.put("Turkish", _TurkishPath);
        for (String lan : pathMap.keySet()) {
            String path = pathMap.get(lan);
            Evaluator evaluator = new Evaluator();
            CoordinationUnionAction actionHandle = new CoordinationUnionAction();
            CoordinationUnionAction.stackAsMemUnit = true;
            Pair<Integer, Integer> result = MultilanguageTest.testRecursion((AbstractAction)actionHandle, new File(path), evaluator);
            System.out.println(String.valueOf(lan) + ":\nstack:(All, Succeeded) = " + result);
            System.out.println("rate = " + 100.0 * (double)result.getSecond().intValue() / (double)result.getFirst().intValue());
            CoordinationUnionAction.stackAsMemUnit = false;
            result = MultilanguageTest.testRecursion((AbstractAction)actionHandle, new File(path), evaluator);
            System.out.println("queue:(All, Succeeded) = " + result);
            System.out.println("rate = " + 100.0 * (double)result.getSecond().intValue() / (double)result.getFirst().intValue());
            System.out.println();
        }
    }

    public static Pair<Integer, Integer> testRecursion(AbstractAction actionHandle, File dir, Evaluator evaluator) {
        return MultilanguageTest.testRecursion(actionHandle, dir, evaluator, null);
    }

    public static Pair<Integer, Integer> testRecursion(AbstractAction actionHandle, File dir, Evaluator evaluator, CCGPARGWriter writer) {
        int all = 0;
        int succ = 0;
        if (dir.isFile()) {
            String PARGpath = dir.getPath();
            CoNLLReader reader = new CoNLLReader(PARGpath);
            try {
                String[][] conll = reader.readNext();
                while (conll != null) {
                    ++all;
                    PredicateArgumentAdjunctDAG dag = PredicateArgumentAdjunctDAG.buildTreeFromCONLL06(conll);
                    List oracles = actionHandle.getOracleActions(dag);
                    if (oracles != null) {
                        ++succ;
                        PredicateArgumentAdjunctDAG recovered = actionHandle.getDAG(dag.sentLen, oracles);
                        evaluator.registry(dag, recovered);
                    } else if (writer != null) {
                        writer.printOneSentenceCoNLL08(dag, null, null);
                    }
                    conll = reader.readNext();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                Pair<Integer, Integer> all_succ = MultilanguageTest.testRecursion(actionHandle, files[i], evaluator, writer);
                all += all_succ.getFirst().intValue();
                succ += all_succ.getSecond().intValue();
                ++i;
            }
        }
        return new Pair<Integer, Integer>(all, succ);
    }
}

