#!/usr/bin/python
# coding=utf-8

from Collins_rules import reorder
import math

def test(testno, parse, reordered, features):
  (r,f) = reorder(parse)
  if reordered != r or features != f:
    print "Test " + str(testno) + " failed"
    if reordered != r:
      print reordered
      print r
    if features != f:
      print features
      print f

if __name__ == "__main__":
  test(1, "(())", "", { 'used_rules': map(math.exp, [0,0,0,0,0,0]), 'countN': math.exp(-1), 'countV': math.exp(-1), 'countP': math.exp(-1), 'countConj': math.exp(-1), 'jump_bins': map(math.exp, [0,0,0,0,0,0,0,0,0,0]) })

  test(2, "( ( (NP (NE*AG Musharrafs) (ADJA*NK letzter) (NN*NK Akt)) ($. ?)) )", "Musharrafs letzter Akt ?", { 'used_rules': map(math.exp, [0,0,0,0,0,0]), 'countN': math.exp(2), 'countV': math.exp(0), 'countP': math.exp(0), 'countConj': math.exp(0), 'jump_bins': map(math.exp, [0,0,0,0,0,0,0,0,0,0]) })

  test(3, "( ( (S (NP*SB (NN*NK General) (NE*NK Musharraf)) (VVFIN*HD betrat) (PP*MO (APPRART*AC am) (ADJA*NK 12.) (NN*NK Oktober) (CARD*NK 1999)) (NP*OA (ART*NK die) (ADJA*NK nationale) (NN*NK Bühne) ($, ,) (CS*RC (S*CJ (KOUS*CP als) (PPER*SB er) (NP*OA (ART*NK eine) (ADJA*NK gewählte) (NN*NK Regierung)) (VVFIN*HD stürzte)) (KON*CD und) (S*CJ (NP*OA (ART*NK ein) (ADJA*NK ehrgeiziges) (NN*NK Nationbuilding-Projekt)) (VVFIN*HD ankündigte))))) ($. .)) )", "General Musharraf betrat am 12. Oktober 1999 die nationale Bühne , als er stürzte eine gewählte Regierung und ein ehrgeiziges Nationbuilding-Projekt ankündigte .", {'used_rules': map(math.exp, [0,1,1,0,0,0]), 'countN': math.exp(7), 'countV': math.exp(3), 'countP': math.exp(1), 'countConj': math.exp(2), 'jump_bins': map(math.exp, [1,1,0,0,0,0,0,0,0,0]) } )

  test(4, "( ( (CS (S*CJ (NP*SB (PIAT*NK Viele) (AP*NK (PP*SBP (APPR*AC von) (ART*NK der) (ADJA*NK politischen) (NN*NK Klasse) (NP*AG (PPOSAT*NK ihres) (NN*NK Landes))) (ADJA*HD disillusionierte)) (NN*NK Pakistanis)) (VVFIN*HD blieben) (ADJD*MO stumm)) ($. ;) (S*CJ (PPER*SB sie) (VVFIN*HD dachten) ($, ,) (S*OC (KOUS*CP dass) (PPER*SB er) (VP*OC (NP*OA (PPOSAT*NK sein) (NN*NK Versprechen)) (ADV*MO vielleicht) (VVINF*HD halten)) (VVFIN*HD würde)))) ($. .)) )", "Viele von der politischen Klasse ihres Landes disillusionierte Pakistanis blieben stumm ; sie dachten , dass er würde halten sein Versprechen vielleicht .", { 'used_rules': map(math.exp, [1,1,1,0,0,0]), 'countN': math.exp(6), 'countV': math.exp(4), 'countP': math.exp(1), 'countConj': math.exp(1), 'jump_bins': map(math.exp, [1,2,0,0,0,0,0,0,0,0]) })

  test(5, "( ( (S (PP*MO (APPRART*AC Am) (ADJA*NK 11.) (NN*NK September) (CARD*NK 2001)) (VVFIN*HD brachten) (NP*SB (ART*NK die) (NN*NK Terroranschläge) (PP*MNR (APPR*AC auf) (NE*NK Amerika))) (NN*OA Musharraf) (PP*MO (APPRART*AC ins) (ADJA*NK internationale) (NN*NK Rampenlicht)) ($, ,) (S*RE (KOUS*CP als) (PPER*SB er) (PRF*OA sich) (AP*MO (ADJD*HD bereit)) (VVFIN*HD erklärte) ($, ,) (CVP*OC (VP*CJ (NP*DA (ART*NK den) (NN*NK Taliban)) (NP*OA (ART*NK den) (NN*NK Laufpass)) (VZ*HD (PTKZU*PM zu) (VVINF*HD geben))) (KON*CD und) (VP*CJ (NP*DA (ART*NK den) (AP*NK (PP*SBP (APPR*AC von) (ART*NK den) (ADJA*NK Vereinigten) (NN*NK Staaten)) (ADJA*HD angeführten)) (NN*NK Krieg)) (PP*MO (APPR*AC gegen) (ART*NK den) (NN*NK Terror)) (VZ*HD (PTKZU*PM zu) (VVINF*HD unterstützen)))))) ($. .)) )", "Am 11. September 2001 die Terroranschläge auf Amerika brachten Musharraf ins internationale Rampenlicht , als er erklärte sich bereit , zu geben den Taliban den Laufpass und zu unterstützen den von den Vereinigten Staaten angeführten Krieg gegen den Terror .", { 'used_rules': map(math.exp, [2,1,2,0,0,0]), 'countN': math.exp(12), 'countV': math.exp(4), 'countP': math.exp(5), 'countConj': math.exp(2), 'jump_bins': map(math.exp, [1,3,0,1,0,0,0,0,0,0]) })

  test(6, "( ( (S (NE*SB Musharraf) (VVFIN*HD ging) (ADJD*MO hart) (PP*MO (APPR*AC gegen) (PIS*NK einige)) (PP*MO (APPR*AC innerhalb) (NE*AG Pakistans) (CAP*NK (ADJA*CJ operierende) (KON*CD bzw.) (AP*CJ (PP*MO (APPR*AC gegen) (ART*NK die) (ADJA*NK indischen) (NN*NK Truppen) (PP*MNR (APPR*AC in) (NE*NK Kaschmir))) (ADJA*HD kämpfende))) (ADJA*NK religiöse) (NN*NK Fanatiker)) (PTKVZ*SVP vor)) ($. .)) )", "Musharraf vor ging hart gegen einige innerhalb Pakistans operierende bzw. gegen die indischen Truppen in Kaschmir kämpfende religiöse Fanatiker .", { 'used_rules': map(math.exp, [0,0,0,1,0,0]), 'countN': math.exp(6), 'countV': math.exp(1), 'countP': math.exp(4), 'countConj': math.exp(1), 'jump_bins': map(math.exp, [0,0,0,0,0,1,0,0,0,0]) })

  test(7, "( ( (CS (S*CJ (S*MO (KOUS*CP Obwohl) (NP*SB (ART*NK die) (NE*NK USA)) (NN*OA Musharraf) (PP*MO (APPR*AC als) (NN*NK Repräsentanten) (NP*AG (ART*NK des) (NN*NK Wandels))) (VVFIN*HD ansahen)) ($, ,) (VAFIN*HD hat) (PPER*SB er) (VP*OC (PRF*DA sich) (PP*MO (APPRART*AC im) (ADJA*NK eigenen) (NN*NK Lande)) (ADV*MO nie) (NP*OA (ADJA*NK politische) (NN*NK Legitimität)) (VVINF*HD erwerben) (VVINF*HD können))) ($, ,) (KON*CD und) (S*CJ (NP*SB (PPOSAT*NK seine) (NN*NK Politik)) (VAFIN*HD wurde) (VP*OC (PP*MO (APPR*AC als) (ADJD*NK widersprüchlich)) (VVPP*HD angesehen)))) ($. .)) )", "Obwohl die USA ansahen Musharraf als Repräsentanten des Wandels , er hat erwerben können sich im eigenen Lande nie politische Legitimität , und seine Politik wurde angesehen als widersprüchlich .", { 'used_rules': map(math.exp, [2,1,2,0,1,0]), 'countN': math.exp(9), 'countV': math.exp(6), 'countP': math.exp(3), 'countConj': math.exp(2), 'jump_bins': map(math.exp, [3,0,3,0,0,0,0,0,0,0]) })

  test(8, "( ( (S (VP*MO (KOUI*CP Anstatt) (NP*OA (ART*NK die) (NN*NK Verantwortung)) (VVIZU*HD für) (VP*OC (CNP*OA (NP*CJ (ART*NK die) (AP*NK (AP*MO (ADV*MO immer) (ADJD*HD schlechter)) (ADJA*HD werdende)) (NN*NK Sicherheitslage) ($LRB *LRB*) (NN*NK für) (S*RC (PRELS*OA die) (NP*SB (ART*NK die) (ADJA*NK regelmäßigen) (NN*NK Selbstmordanschläge)) (NP*PD (ART*NK ein) (NN*NK Beleg)) (VAFIN*HD sind))) ($LRB *RRB*) (KON*CD und) (NP*CJ (ART*NK die) (ADJA*NK zunehmende) (NN*NK Talibanisierung) (NP*AG (ART*NK der) (NN*NK Stammesgebiete)))) (VZ*HD (PTKZU*PM zu) (VVINF*HD übernehmen)))) ($, ,) (VAFIN*HD hat) (NE*SB Musharraf) (VP*OC (VVPP*HD versucht)) ($, ,) (VP*RE (NP*OA (CNP*NK (NP*CJ (ART*NK der) (NN*NK Justiz)) (KON*CD und) (NP*CJ (ART*NK den) (NN*NK Medien)))) (VP*OC (NP*OA (ART*NK die) (NN*NK Schuld)) (VVINF*HD hierfür)) (VZ*HD (PTKZU*PM zu) (VVINF*HD geben)))) ($. .))", "für Anstatt die Verantwortung zu übernehmen die immer schlechter werdende Sicherheitslage *LRB* für die die regelmäßigen Selbstmordanschläge sind ein Beleg *RRB* und die zunehmende Talibanisierung der Stammesgebiete , Musharraf hat versucht , zu geben hierfür der Justiz und den Medien die Schuld .", { 'used_rules': map(math.exp, [4,1,2,0,1,0]), 'countN': math.exp(11), 'countV': math.exp(7), 'countP': math.exp(0), 'countConj': math.exp(4), 'jump_bins': map(math.exp, [2,4,1,0,0,0,1,0,0,0]) })

  test(9, "( ( (@ (@ (S (ADJD*PD Sicher) ($, ,) (CS*OC (S*CJ (PP*MO (APPR*AC in) (PIAT*NK einigen) (NN*NK Fällen)) (VAFIN*HD war) (NP*SB (ART*NK der) (ADJA*NK richterliche) (NN*NK Aktivismus)) (ADJD*MO offensichtlich) ($LRB *LRB*) (S*MO (ADV*MO auch) (KOUS*CP wenn) (PPER*SB er) (PRF*OA sich) (PP*MO (APPRART*AC im) (NN*NK Rahmen) (NP*AG (ART*NK der) (NN*NK Verfassung))) (VVFIN*HD abspielte))) ($LRB *RRB*) ($, ,) (KON*CD und) (S*CJ (NP*SB (ADV*MO auch) (ART*NK die) (NN*NK Medien)) (VAFIN*HD haben) (VP*OC (NN*OA Fehler) (VVPP*HD gemacht))))) ($. .)) (S (KON*JU Doch) (AVP*MO (ADV*HD egal) ($, ,) (S*MO (AVP*MO (PWAV*MO wie) (ADV*HD sehr)) (PIS*SB man) (NP*OA (PPOSAT*NK seine) (NN*NK Fantasie)) (VVFIN*HD strapaziert) ($. :) (VP*RE (PP*OP (APPR*AC Mit) (CNP*NK (NP*CJ (ADJA*NK religiösem) (NN*NK Extremismus)) (KON*CD oder) (NN*CJ Unterstützung))) (VVIZU*HD für)))) (NP*SB (ART*NK die) (NN*NK Militanten)) (VVFIN*HD lässt) (PRF*OA sich) (PDS*OA dies) (PTKNEG*NG nicht) (VP*OC (PP*CVC (APPR*AC in) (NN*NK Verbindung)) (VVINF*HD bringen)))) ($. .)) )", "Sicher , in einigen Fällen der richterliche Aktivismus war offensichtlich *LRB* auch wenn er abspielte sich im Rahmen der Verfassung *RRB* , und auch die Medien haben gemacht Fehler . Doch egal , wie sehr seine Fantasie man strapaziert : für Mit religiösem Extremismus oder Unterstützung die Militanten lässt nicht bringen sich dies in Verbindung .", { 'used_rules': map(math.exp, [3,1,3,0,1,1]), 'countN': math.exp(16), 'countV': math.exp(8), 'countP': math.exp(4), 'countConj': math.exp(5), 'jump_bins': map(math.exp, [4,4,1,0,0,0,0,0,0,0]) })

  test(10, "( ( (S (NP*SB (ART*NK Das) (NN*NK Sparverhalten) (NP*AG (ART*NK der) (ADJA*NK älteren) (NN*NK Menschen) (PP*MNR (APPR*AC in) (NE*NK Europa)))) (VVFIN*HD deutet) (PP*OP (PROAV*PH darauf)) (PTKVZ*SVP hin) ($, ,) (S*RE (KOUS*CP dass) (PPER*SB sie) (PRF*OA sich) (PP*OP (APPR*AC um) (ART*NK die) (ADJA*NK schwindenden) (NN*NK Arbeitnehmerzahlen)) (VVFIN*HD sorgen) ($, ,) (VP*OC (NP*OA (PRELAT*NK deren) (NN*NK Steuervolumen)) (PTKNEG*NG nicht) (VVINF*HD ausreichen) (VVINF*HD könnte) ($, ,) (VP*MO (KOUI*CP um) (NP*OA (ART*NK die) (NN*NK Renten)) (ADJD*MO aufrecht) (VZ*HD (PTKZU*PM zu) (VVINF*HD erhalten)))))) ($. .)) )", "Das Sparverhalten der älteren Menschen in Europa hin deutet darauf , dass sie sorgen nicht ausreichen könnte zu erhalten sich um die schwindenden Arbeitnehmerzahlen , deren Steuervolumen , um die Renten aufrecht .", { 'used_rules': map(math.exp, [2,1,1,1,3,1]), 'countN': math.exp(8), 'countV': math.exp(5), 'countP': math.exp(2), 'countConj': math.exp(3), 'jump_bins': map(math.exp, [2,2,2,3,0,0,0,0,0,0]) })

