import numpy as np
import h5py
from keras.models import model_from_json
from hawkes_attention import Att_Hawkes, Att_Hawkes_user, Elmo_Layer
from sklearn.metrics import f1_score, accuracy_score

haw = 1   # 0: combi_uni; 1: combi_user


def evaluate(model, X_test, Y_test):
    Y_pred = model.predict(X_test)
    Y_pred = np.asarray([[1, 0] if i[0] > i[1] else [0, 1] for i in Y_pred])
    f1 = f1_score(Y_test, Y_pred, average=None)
    acc = accuracy_score(Y_test, Y_pred)

    return f1, acc


if haw == 0:
    json_file = open('trained_models/combi_uni.json', 'r')
    loaded_model_json = json_file.read()
    json_file.close()
    model = model_from_json(loaded_model_json, custom_objects={'Elmo_Layer':Elmo_Layer, 'Att_Hawkes': Att_Hawkes})
    model.load_weights("trained_models/combi_uni.h5")
    f = h5py.File('combi_uni.hdf5', 'r')
else:
    json_file = open('trained_models/combi_user.json', 'r')
    loaded_model_json = json_file.read()
    json_file.close()
    model = model_from_json(loaded_model_json, custom_objects={'Elmo_Layer':Elmo_Layer, 'Att_Hawkes_user': Att_Hawkes_user})
    model.load_weights("trained_models/combi_user.h5")
    f = h5py.File('combi_user.hdf5', 'r')

    X_info_test = f['X_info_test']


X_elmo_test = f['X_elmo_test']
X_gc_test = f['X_gc_test']
X_info_bi_test = f['X_info_bi_test']
AUX_test = f['AUX_test']
Y_test = f['Y_test']


if haw == 0:
    f1, acc = evaluate(model, [X_elmo_test, X_gc_test, X_info_bi_test, AUX_test], Y_test)
else:
    f1, acc = evaluate(model,[X_elmo_test, X_gc_test, X_info_bi_test, X_info_test, AUX_test], Y_test)

print f1, acc
f.close()
