﻿#!/usr/bin/python
# -*- encoding=utf-8 -*-



# usage:	python evaluatePrecRec.py <parser> <grammar> <yields> <annotated-yields> <output>


#	Evaluates a generalized Grammar where all contexts have been deleted (i.e. the parsing task)
#	yields are the surface-strings of all gold-examples, annotated-yields
#	are the surface-strings together with their meaning, in exactly
#	the same order
#
#	One example per line
#
#	Every example is parsed using Grammar and parser, and the meaning is read
#	off at the S-Node of the MOST PROBABLE parse
#
#	If this meaning matches the one given in the Gold-Standard, this is considered
#	correct, if not, it is considered a mistake
#
#	If no parse is returned (should not happen), this is also considered a mistake
#
#	A trace of the evaluation is written to output, every correct example begins
#	with True, every mistake with False and a did-not-parse mistake with PROBLEM,
#	so that you can simply grep the output file


usage = """evaluate.py <parser> <grammar> <yields> <annotated-yields> <output>"""


import sys
import os
import re

meaning = re.compile(r"S_([osv]*_)?([^ ]+)")

def chomp(s):
	return s.rstrip('\r\n')

if __name__ == '__main__':
	correct = 0
	total = 0
	parser = sys.argv[1]
	grammarfile = sys.argv[2]
	goldyield = sys.argv[3]
	goldfile = sys.argv[4]
	outputfile = sys.argv[5]
	print "Parsing the goldyield with the grammar"
	os.system(parser+" "+goldyield+" 0 "+grammarfile+" > parsedgold")
	sentences = zip([x.rstrip('\r\n') for x in file("parsedgold","r").readlines()],[y.rstrip('\r\n').split("::")[1].split(" --> ") for y in file(goldfile,"r").readlines()])
	output = file(outputfile,"w")
	for x,gold in sentences:
		total += 1
		if x == "parse_failure.":
			print "Couldn't parse "+gold[0]
			output.write("PROBLEM::Couldn't parse "+gold[0]+"\n")
			continue
		modelMeaning = meaning.search(x)
		modelMeaning = modelMeaning.group(2)
		atomic = modelMeaning.split("_",1)
		if not len(atomic) == 1:
			if atomic[0] == "playmode":
				modelMeaning = atomic[0]+"("+atomic[1]+")"
			else:
				modelMeaning = atomic[0]+"("+atomic[1].replace("_",",")+")"
		
		
		if modelMeaning == gold[1]:
			correct += 1
#			print "True::",gold[0]
			output.write("True::"+gold[0]+" Model:"+modelMeaning+"\n")
		else:
#			print "False::",gold[0],"Model:",modelMeaning,"Gold:",gold[1]
			output.write("False::"+gold[0]+" Model:"+modelMeaning+" Gold:"+gold[1]+"\n")
	acc = float(correct)/float(total)
	print "Accuracy",acc
	output.write("----\nAccuracy:"+str(acc))
	output.close()
