package szte.csd.indicatorsel;

import java.util.Map;

/**
 * 
 * The mutual information indicator selector.
 * MI(C,w) = SUM p(c,w)*log p(c|w)/p(c)
 * where C \in {POS,NEG} the classes
 *
 */
public class MutualInfoIndicatorSelector extends InformtaionTheoryIndicatorSelection {
 
  public double calcFeatureScore(Map<Boolean, Double> df, Map<Boolean, Double> n) {
    double size= n.get(true)+n.get(false); 
    double py  = n.get(true)/size;
    double pxy = df.get(true)/size;
    double px  = (df.get(true)+df.get(false))/size;
    double MI  = pxy * Math.log(pxy/px/py);
           pxy = df.get(false)/size;
           py  = n.get(false)/size;
           MI  += pxy * Math.log(pxy/px/py);
       
      if(MI>0.3 || MI<-0.0001)
        System.err.println("MI="+MI);
    return MI;
  }
}
