/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.medline;

import com.aliasi.medline.Abstract;
import com.aliasi.medline.ArticleDate;
import com.aliasi.medline.AuthorList;
import com.aliasi.medline.DataBankList;
import com.aliasi.medline.ELocationId;
import com.aliasi.medline.GrantList;
import com.aliasi.medline.Journal;
import com.aliasi.util.Strings;
import com.aliasi.xml.DelegateHandler;
import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.TextAccumulatorHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class Article {
    private final String mPublicationModel;
    private final Journal mJournal;
    private final String mArticleTitle;
    private final String mPagination;
    private final ELocationId[] mELocationIds;
    private final Abstract mAbstract;
    private final String mAffiliation;
    private final AuthorList mAuthorList;
    private final String[] mLanguages;
    private final DataBankList mDataBankList;
    private final GrantList mGrantList;
    private final String[] mPublicationTypes;
    private final String mVernacularTitle;
    private final ArticleDate mArticleDate;
    private static final String AUTHORS_TRANS_MARKER = " (author's trans)";
    static final ELocationId[] EMPTY_E_LOCATION_ID_ARRAY = new ELocationId[0];

    @Deprecated
    Article(String publicationModel, Journal journal, String articleTitle, String pagination, ELocationId[] eLocationIds, Abstract abstrct, String affiliation, AuthorList authorList, String[] languages, DataBankList dataBankList, GrantList grantList, String[] publicationTypes, String vernacularTitle, ArticleDate articleDate) {
        this.mPublicationModel = publicationModel;
        this.mJournal = journal;
        this.mArticleTitle = articleTitle;
        this.mPagination = pagination;
        this.mELocationIds = eLocationIds;
        this.mAbstract = abstrct;
        this.mAffiliation = affiliation;
        this.mAuthorList = authorList;
        this.mLanguages = languages;
        this.mDataBankList = dataBankList;
        this.mGrantList = grantList;
        this.mPublicationTypes = publicationTypes;
        this.mVernacularTitle = vernacularTitle;
        this.mArticleDate = articleDate;
    }

    public String publicationModel() {
        return this.mPublicationModel;
    }

    public String pagination() {
        return this.mPagination;
    }

    @Deprecated
    public ELocationId[] eLocationIds() {
        return this.mELocationIds;
    }

    @Deprecated
    public Journal journal() {
        return this.mJournal;
    }

    public String articleTitle() {
        return this.mArticleTitle;
    }

    public boolean articleTranslated() {
        return this.articleTitle().length() > 1 && this.articleTitle().charAt(0) == '[' && this.articleTitle().charAt(this.articleTitle().length() - 1) == ']';
    }

    public String articleTitleText() {
        if (!this.articleTranslated()) {
            return this.articleTitle();
        }
        String baseText = this.articleTitle().substring(1, this.articleTitle().length() - 1);
        if (baseText.endsWith(AUTHORS_TRANS_MARKER)) {
            return baseText.substring(0, baseText.length() - AUTHORS_TRANS_MARKER.length());
        }
        return baseText;
    }

    @Deprecated
    public Abstract abstrct() {
        return this.mAbstract;
    }

    @Deprecated
    public AuthorList authorList() {
        return this.mAuthorList;
    }

    public String affiliation() {
        return this.mAffiliation;
    }

    public String[] languages() {
        return this.mLanguages;
    }

    @Deprecated
    public DataBankList dataBankList() {
        return this.mDataBankList;
    }

    @Deprecated
    public GrantList grantList() {
        return this.mGrantList;
    }

    public String[] publicationTypes() {
        return this.mPublicationTypes;
    }

    public String vernacularTitle() {
        return this.mVernacularTitle;
    }

    @Deprecated
    public ArticleDate articleDate() {
        return this.mArticleDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("Title=");
        sb.append(this.articleTitle());
        sb.append(" Authors=");
        sb.append(this.authorList());
        sb.append(" Publication Model=");
        sb.append(this.publicationModel());
        sb.append(" Journal=" + this.journal());
        if (this.pagination().length() > 0) {
            sb.append(" Pagination=" + this.pagination());
        }
        if (this.abstrct() != null && this.abstrct().text().length() > 0) {
            sb.append(" Abstract=");
            sb.append(this.abstrct());
        }
        if (this.affiliation().length() > 0) {
            sb.append(" Affiliation=");
            sb.append(this.affiliation());
        }
        sb.append(" Languages=");
        sb.append(Arrays.asList(this.languages()));
        if (this.dataBankList() != null) {
            sb.append(" Data Banks=");
            sb.append(this.dataBankList());
        }
        if (this.grantList() != null) {
            sb.append(" Grant List=");
            sb.append(this.grantList());
        }
        if (this.publicationTypes().length > 0) {
            sb.append(" Publication Types=");
            sb.append(Arrays.asList(this.publicationTypes()));
        }
        if (this.vernacularTitle() != null && this.vernacularTitle().length() > 0) {
            sb.append(" Vernacular Title=");
            sb.append(this.vernacularTitle());
        }
        if (this.articleDate() != null) {
            sb.append(" Electronic Article Pub Date=");
            sb.append(this.articleDate());
        }
        sb.append('}');
        return sb.toString();
    }

    @Deprecated
    static class Handler
    extends DelegateHandler {
        private String mPublicationModel;
        private final Journal.Handler mJournalHandler;
        private final TextAccumulatorHandler mArticleTitleHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mMedlinePaginationHandler = new TextAccumulatorHandler();
        private final Abstract.Handler mAbstractHandler;
        private final TextAccumulatorHandler mAffiliationHandler = new TextAccumulatorHandler();
        String mPagination;
        private final ELocationId.Handler mELocationIdHandler = new ELocationId.Handler();
        private final List<ELocationId> mELocationIdList = new ArrayList<ELocationId>();
        private final TextAccumulatorHandler mStartPageHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mEndPageHandler = new TextAccumulatorHandler();
        private final AuthorList.Handler mAuthorListHandler;
        private final List<String> mLanguageList = new ArrayList<String>();
        private final TextAccumulatorHandler mLanguageHandler = new TextAccumulatorHandler();
        private final DataBankList.Handler mDataBankListHandler;
        private final GrantList.Handler mGrantListHandler;
        private final List<String> mPublicationTypeList = new ArrayList<String>();
        private final TextAccumulatorHandler mPublicationTypeHandler = new TextAccumulatorHandler();
        private final TextAccumulatorHandler mVernacularTitleHandler = new TextAccumulatorHandler();
        private final ArticleDate.Handler mArticleDateHandler;

        public Handler(DelegatingHandler delegator) {
            super(delegator);
            this.mJournalHandler = new Journal.Handler(delegator);
            this.mAbstractHandler = new Abstract.Handler(delegator);
            this.mAuthorListHandler = new AuthorList.Handler(delegator);
            this.mDataBankListHandler = new DataBankList.Handler(delegator);
            this.mGrantListHandler = new GrantList.Handler(delegator);
            this.mArticleDateHandler = new ArticleDate.Handler(delegator);
            this.setDelegate("Journal", this.mJournalHandler);
            this.setDelegate("ArticleTitle", this.mArticleTitleHandler);
            this.setDelegate("MedlinePgn", this.mMedlinePaginationHandler);
            this.setDelegate("ELocationId", this.mELocationIdHandler);
            this.setDelegate("StartPage", this.mStartPageHandler);
            this.setDelegate("EndPage", this.mEndPageHandler);
            this.setDelegate("Abstract", this.mAbstractHandler);
            this.setDelegate("Affiliation", this.mAffiliationHandler);
            this.setDelegate("AuthorList", this.mAuthorListHandler);
            this.setDelegate("Language", this.mLanguageHandler);
            this.setDelegate("DataBankList", this.mDataBankListHandler);
            this.setDelegate("GrantList", this.mGrantListHandler);
            this.setDelegate("PublicationType", this.mPublicationTypeHandler);
            this.setDelegate("VernacularTitle", this.mVernacularTitleHandler);
            this.setDelegate("ElectronicPubDate", this.mArticleDateHandler);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.mJournalHandler.reset();
            this.mArticleTitleHandler.reset();
            this.mMedlinePaginationHandler.reset();
            this.mPagination = null;
            this.mStartPageHandler.reset();
            this.mEndPageHandler.reset();
            this.mAbstractHandler.reset();
            this.mAffiliationHandler.reset();
            this.mAuthorListHandler.reset();
            this.mLanguageList.clear();
            this.mDataBankListHandler.reset();
            this.mGrantListHandler.reset();
            this.mPublicationTypeList.clear();
            this.mVernacularTitleHandler.reset();
            this.mArticleDateHandler.reset();
            this.mELocationIdList.clear();
            super.startDocument();
        }

        public void startElement(String x, String y, String qName, Attributes atts) throws SAXException {
            if (qName.equals("Article")) {
                this.mPublicationModel = atts.getValue("PubModel");
            }
            super.startElement(x, y, qName, atts);
        }

        public Article getArticle() {
            String[] languages = this.mLanguageList.toArray(Strings.EMPTY_STRING_ARRAY);
            String[] publicationTypes = this.mPublicationTypeList.toArray(Strings.EMPTY_STRING_ARRAY);
            ELocationId[] eLocationIds = this.mELocationIdList.toArray(EMPTY_E_LOCATION_ID_ARRAY);
            return new Article(this.mPublicationModel, this.mJournalHandler.getJournal(), this.mArticleTitleHandler.getText(), this.mPagination, eLocationIds, this.mAbstractHandler.getAbstract(), this.mAffiliationHandler.getText(), this.mAuthorListHandler.getAuthorList(), languages, this.mDataBankListHandler.getDataBankList(), this.mGrantListHandler.getGrantList(), publicationTypes, this.mVernacularTitleHandler.getText(), this.mArticleDateHandler.getArticleDate());
        }

        public void finishDelegate(String qName, DefaultHandler handler) {
            if (qName.equals("MedlinePgn")) {
                this.mPagination = this.mMedlinePaginationHandler.getText();
            } else if (qName.equals("StartPage")) {
                this.mPagination = this.mStartPageHandler.getText();
            } else if (qName.equals("EndPage")) {
                this.mPagination = this.mPagination.length() > 0 ? this.mPagination + "-" + this.mEndPageHandler.getText() : this.mEndPageHandler.getText();
            } else if (qName.equals("Language")) {
                this.mLanguageList.add(this.mLanguageHandler.getText());
            } else if (qName.equals("PublicationType")) {
                this.mPublicationTypeList.add(this.mPublicationTypeHandler.getText());
            } else if (qName.equals("ELocationId")) {
                this.mELocationIdList.add(this.mELocationIdHandler.getELocationId());
            }
        }
    }
}

