/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import com.aliasi.util.Math;
import java.io.IOException;
import java.io.InputStream;

public class BitInput {
    private final InputStream mIn;
    private int mNextByte;
    private int mNextBitIndex;
    private boolean mEndOfStream = false;
    static final byte ZERO_BYTE = 0;
    static int ALL_ONES_INT = -1;

    public BitInput(InputStream in) throws IOException {
        this.mIn = in;
        this.readAhead();
    }

    public long available() throws IOException {
        return this.mEndOfStream ? 0L : (long)this.mNextBitIndex + 1L + 8L * (long)this.mIn.available();
    }

    public void close() throws IOException {
        this.mEndOfStream = true;
        this.mIn.close();
    }

    public boolean endOfStream() {
        return this.mEndOfStream;
    }

    public long skip(long numBits) throws IOException {
        if (numBits < 0L) {
            String msg = "Require positive number of bits to skip. Found numBits=" + numBits;
            throw new IllegalArgumentException(msg);
        }
        if ((long)this.mNextBitIndex >= numBits) {
            this.mNextBitIndex = (int)((long)this.mNextBitIndex - numBits);
            return numBits;
        }
        long numBitsSkipped = this.mNextBitIndex + 1;
        long numBitsLeft = numBits - numBitsSkipped;
        long bytesToSkip = numBitsLeft / 8L;
        long bytesSkipped = this.mIn.skip(bytesToSkip);
        numBitsSkipped += 8L * bytesSkipped;
        if (bytesSkipped < bytesToSkip) {
            this.mEndOfStream = true;
            return numBitsSkipped;
        }
        this.readAhead();
        if (this.mEndOfStream) {
            return numBitsSkipped;
        }
        this.mNextBitIndex = 7 - (int)numBitsLeft % 8;
        return numBits;
    }

    public boolean readBit() throws IOException {
        switch (this.mNextBitIndex--) {
            case 0: {
                boolean result = (this.mNextByte & 1) != 0;
                this.readAhead();
                return result;
            }
            case 1: {
                return (this.mNextByte & 2) != 0;
            }
            case 2: {
                return (this.mNextByte & 4) != 0;
            }
            case 3: {
                return (this.mNextByte & 8) != 0;
            }
            case 4: {
                return (this.mNextByte & 0x10) != 0;
            }
            case 5: {
                return (this.mNextByte & 0x20) != 0;
            }
            case 6: {
                return (this.mNextByte & 0x40) != 0;
            }
            case 7: {
                return (this.mNextByte & 0x80) != 0;
            }
        }
        String msg = "Index out of bounds. mNextBitIndex=" + this.mNextBitIndex;
        throw new IOException(msg);
    }

    public int readUnary() throws IOException {
        int result = 1;
        while (!this.endOfStream() && this.mNextBitIndex != 7) {
            if (this.readBit()) {
                return result;
            }
            ++result;
        }
        while (!this.endOfStream() && this.mNextByte == 0) {
            result += 8;
            this.mNextByte = this.mIn.read();
            if (this.mNextByte != -1) continue;
            String msg = "Final sequence of 0 bits with no 1";
            throw new IOException(msg);
        }
        while (!this.readBit()) {
            ++result;
        }
        return result;
    }

    public void skipUnary() throws IOException {
        while (!this.endOfStream() && this.mNextBitIndex != 7) {
            if (!this.readBit()) continue;
            return;
        }
        while (!this.endOfStream() && this.mNextByte == 0) {
            this.mNextByte = this.mIn.read();
            if (this.mNextByte != -1) continue;
            String msg = "Final sequence of 0 bits with no 1";
            throw new IOException(msg);
        }
        while (!this.readBit()) {
        }
    }

    public long readGamma() throws IOException {
        int numBits = this.readUnary();
        if (numBits > 63) {
            String msg = "Gamma code binary part must be <= 63 bits. Found numBits=" + numBits;
            throw new IOException(msg);
        }
        return this.readRest(numBits - 1, 1L);
    }

    public void skipGamma() throws IOException {
        int numBits = this.readUnary();
        BitInput.checkGamma(numBits);
        this.skip(numBits - 1);
    }

    public long readDelta() throws IOException {
        long numBits = this.readGamma();
        BitInput.checkDelta(numBits);
        if (numBits > 63L) {
            String msg = "Delta code must use <= 63 bits for fixed portion. Found number of remaining bits=" + numBits;
            throw new IOException(msg);
        }
        return this.readRest((int)numBits - 1, 1L);
    }

    public void skipDelta() throws IOException {
        long numBits = this.readGamma();
        BitInput.checkDelta(numBits);
        this.skip(numBits - 1L);
    }

    public long readBinary(int numBits) throws IOException {
        if (numBits > 63) {
            String msg = "Cannot read more than 63 bits into positive long. Found numBits=" + numBits;
            throw new IllegalArgumentException(msg);
        }
        if (numBits < 1) {
            String msg = "Number of bits to read must be > 0. Found numBits=" + numBits;
            throw new IllegalArgumentException(msg);
        }
        long result = this.readBit() ? 1L : 0L;
        return this.readRest(numBits - 1, result);
    }

    public long readRice(int numFixedBits) throws IOException {
        if (numFixedBits < 1) {
            String msg = "Rice coding requires a number of fixed bits > 0. Found numFixedBits=" + numFixedBits;
            throw new IllegalArgumentException(msg);
        }
        if (numFixedBits > 63) {
            String msg = "Rice coding requires a number of fixed bits < 64.Found numFixedBits=" + numFixedBits;
            throw new IllegalArgumentException(msg);
        }
        long prefixBits = this.readUnary();
        long remainder = this.readBinary(numFixedBits);
        long q = prefixBits - 1L;
        long div = q << numFixedBits;
        return div + (remainder + 1L);
    }

    public void skipRice(int numFixedBits) throws IOException {
        this.skipUnary();
        this.skip(numFixedBits);
    }

    public long readFibonacci() throws IOException {
        long[] fibs = Math.FIBONACCI_SEQUENCE;
        long sum = 0L;
        for (int i = 0; i < fibs.length && !this.endOfStream(); ++i) {
            if (!this.readBit()) continue;
            sum += fibs[i++];
            if (this.endOfStream() || !this.readBit()) continue;
            return sum;
        }
        String msg = "Ran off end of input or beyond maximum length  without finding two consecutive 1s";
        throw new IOException(msg);
    }

    public void skipFibonacci() throws IOException {
        while (!this.endOfStream()) {
            if (!this.readBit() || this.endOfStream() || !this.readBit()) continue;
            return;
        }
        String msg = "Ran off end of input without finding two consecutive 1s";
        throw new IOException(msg);
    }

    long readRest(int numBits, long result) throws IOException {
        if (numBits == 0) {
            return result;
        }
        this.notEndOfStream();
        if (this.mNextBitIndex >= numBits) {
            this.mNextBitIndex -= numBits;
            return result << numBits | BitInput.sliceBits2(this.mNextByte, this.mNextBitIndex + 1, numBits + 1);
        }
        numBits -= this.mNextBitIndex + 1;
        result = result << this.mNextBitIndex + 1 | BitInput.sliceBits2(this.mNextByte, 0, this.mNextBitIndex + 1);
        while (numBits >= 8) {
            int nextByte = this.mIn.read();
            if (nextByte == -1) {
                this.mEndOfStream = true;
                String msg = "Premature end of stream reading binary - mid.";
                throw new IOException(msg);
            }
            result = result << 8 | (long)nextByte;
            numBits -= 8;
        }
        this.readAhead();
        if (numBits == 0) {
            return result;
        }
        this.notEndOfStream();
        this.mNextBitIndex = 7 - numBits;
        return result << numBits | BitInput.sliceBits2(this.mNextByte, this.mNextBitIndex + 1, numBits);
    }

    private void readAhead() throws IOException {
        if (this.mEndOfStream) {
            return;
        }
        this.mNextByte = this.mIn.read();
        if (this.mNextByte == -1) {
            this.mEndOfStream = true;
            return;
        }
        this.mNextBitIndex = 7;
    }

    private void notEndOfStream() throws IOException {
        if (this.endOfStream()) {
            String msg = "End of stream reached prematurely.";
            throw new IOException(msg);
        }
    }

    static long leastSignificantBits2(int n, int numBits) {
        return ALL_ONES_INT >>> 32 - numBits & n;
    }

    static long sliceBits2(int n, int leastSignificantBit, int numBits) {
        return BitInput.leastSignificantBits2(n >>> leastSignificantBit, numBits);
    }

    static void checkGamma(int numBits) throws IOException {
        if (numBits <= 63) {
            return;
        }
        String msg = "Gamma code binary part must be <= 63 bits. Found numBits=" + numBits;
        throw new IOException(msg);
    }

    static void checkDelta(long numBits) throws IOException {
        if (numBits <= 63L) {
            return;
        }
        String msg = "Delta code binary part must be <= 63 bits. Number of bits specified=" + numBits;
        throw new IOException(msg);
    }
}

